/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public final class ConfigTree
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ConfigNode mRoot = new ConfigNode(null, null);

    public ConfigNode getRoot() {
        return this.mRoot;
    }

    public List<ConfigNode> getAllNodes() {
        ArrayList<ConfigNode> nodes = new ArrayList<ConfigNode>();
        LinkedList<ConfigNode> stack = new LinkedList<ConfigNode>();
        stack.addAll(this.getRoot().getChildren());
        while (!stack.isEmpty()) {
            ConfigNode n = (ConfigNode)stack.pop();
            nodes.add(n);
            for (ConfigNode c : n.getChildren()) {
                stack.addFirst(c);
            }
        }
        return nodes;
    }

    public boolean containsKey(String key) {
        return null != this.get(key);
    }

    public ConfigNode get(String key) {
        String[] parts = ConfigTree.splitKey(key);
        ConfigNode n = this.getRoot();
        for (int i = 0; i < parts.length && null != (n = n.getChild(parts[i])); ++i) {
        }
        return n;
    }

    public ConfigNode getOrCreate(String key, Object initialValue) {
        String[] parts = ConfigTree.splitKey(key);
        ConfigNode n = this.getRoot();
        for (int i = 0; i < parts.length; ++i) {
            n = i + 1 == parts.length ? n.getOrCreateChild(parts[i], initialValue) : n.getOrCreateChild(parts[i], null);
        }
        return n;
    }

    public ConfigNode remove(String key) {
        ConfigNode n = this.get(key);
        if (null != n) {
            ConfigNode parent = n.getParent();
            if (null != parent) {
                return parent.removeChild(n.getName());
            }
            return null;
        }
        return null;
    }

    public void clear() {
        this.mRoot.clear();
    }

    public void load(Properties props) {
        this.clear();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            this.getOrCreate(key, null).setValue(value);
        }
    }

    public void load(Map<String, Object> map) {
        this.clear();
        for (Map.Entry<String, Object> e : map.entrySet()) {
            String key = e.getKey();
            Object value = e.getValue();
            this.getOrCreate(key, null).setValue(value);
        }
    }

    private static String[] splitKey(String key) {
        return key.split("\\.");
    }

    private static String toString(Object o, String defaultValue) {
        if (null == o) {
            return defaultValue;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }

    private static Boolean toBoolean(Object o, Boolean defaultValue) {
        if (null == o) {
            return defaultValue;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            return 1 == ((Number)o).intValue();
        }
        if (o instanceof String) {
            String s = ((String)o).trim().toLowerCase();
            return "true".equals(s) || "yes".equals(s) || "1".equals(s);
        }
        throw new IllegalArgumentException("Conversion to Boolean failed");
    }

    private static Integer toInteger(Object o, Integer defaultValue) {
        if (null == o) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof String) {
            return Integer.parseInt(((String)o).trim());
        }
        throw new IllegalArgumentException("Conversion to Integer failed");
    }

    private static Long toLong(Object o, Long defaultValue) {
        if (null == o) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof String) {
            return Long.parseLong(((String)o).trim());
        }
        throw new IllegalArgumentException("Conversion to Long failed");
    }

    private static Float toFloat(Object o, Float defaultValue) {
        if (null == o) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return Float.valueOf(((Number)o).floatValue());
        }
        if (o instanceof String) {
            return Float.valueOf(Float.parseFloat(((String)o).trim()));
        }
        throw new IllegalArgumentException("Conversion to Float failed");
    }

    private static Double toDouble(Object o, Double defaultValue) {
        if (null == o) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            return Double.parseDouble(((String)o).trim());
        }
        throw new IllegalArgumentException("Conversion to Double failed");
    }

    private static List<String> toStringList(Object o, List<String> defaultValue) {
        if (null == o) {
            return defaultValue;
        }
        if (o instanceof String) {
            String[] elements = ((String)o).split(",");
            ArrayList<String> list = new ArrayList<String>(elements.length);
            for (String e : elements) {
                list.add(e.trim());
            }
            return list;
        }
        throw new IllegalArgumentException("Conversion to String List failed");
    }

    public static final class ConfigNode
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private ConfigNode mParent;
        private String mName;
        private String mKey;
        private ConcurrentMap<String, ConfigNode> mChildren = new ConcurrentHashMap<String, ConfigNode>();
        private volatile Object mValue = null;

        ConfigNode() {
        }

        public ConfigNode(ConfigNode parent, String name) {
            this.mParent = parent;
            this.mName = name;
            this.mKey = null == this.mName || null == this.mParent ? null : (this.mParent.getKey() == null ? this.mName : this.mParent.getKey() + "." + this.mName);
        }

        public ConfigNode getParent() {
            return this.mParent;
        }

        public String getName() {
            return this.mName;
        }

        public String getKey() {
            return this.mKey;
        }

        public Object getValue() {
            return this.mValue;
        }

        public void setValue(Object value) {
            this.mValue = value;
        }

        public Boolean booleanValue(Boolean defaultValue) {
            return ConfigTree.toBoolean(this.mValue, defaultValue);
        }

        public String stringValue(String defaultValue) {
            return ConfigTree.toString(this.mValue, defaultValue);
        }

        public Integer integerValue(Integer defaultValue) {
            return ConfigTree.toInteger(this.mValue, defaultValue);
        }

        public Long longValue(Long defaultValue) {
            return ConfigTree.toLong(this.mValue, defaultValue);
        }

        public Float floatValue(Float defaultValue) {
            return ConfigTree.toFloat(this.mValue, defaultValue);
        }

        public Double doubleValue(Double defaultValue) {
            return ConfigTree.toDouble(this.mValue, defaultValue);
        }

        public List<String> stringList(List<String> defaultValue) {
            return ConfigTree.toStringList(this.mValue, defaultValue);
        }

        public Set<String> getChildNames() {
            return Collections.unmodifiableSet(this.mChildren.keySet());
        }

        public Collection<ConfigNode> getChildren() {
            return Collections.unmodifiableCollection(this.mChildren.values());
        }

        public ConfigNode getChild(String name) {
            return (ConfigNode)this.mChildren.get(name);
        }

        public ConfigNode getOrCreateChild(String name, Object initialValue) {
            ConfigNode child = (ConfigNode)this.mChildren.get(name);
            if (null == child) {
                child = new ConfigNode(this, name);
                child.setValue(initialValue);
                ConfigNode oldChild = this.mChildren.putIfAbsent(name, child);
                if (null != oldChild) {
                    child = oldChild;
                }
            }
            return child;
        }

        public ConfigNode removeChild(String name) {
            ConfigNode n = (ConfigNode)this.mChildren.remove(name);
            return n;
        }

        public Object getChildValue(String name) {
            ConfigNode child = this.getChild(name);
            if (null == child) {
                return null;
            }
            return child.getValue();
        }

        public void setChildValue(String name, Object value) {
            this.getOrCreateChild(name, null).setValue(value);
        }

        public String getChildStringValue(String name, String defaultValue) {
            ConfigNode child = this.getChild(name);
            if (null == child) {
                return defaultValue;
            }
            return child.stringValue(defaultValue);
        }

        public Boolean getChildBooleanValue(String name, Boolean defaultValue) {
            ConfigNode child = this.getChild(name);
            if (null == child) {
                return defaultValue;
            }
            return child.booleanValue(defaultValue);
        }

        public Integer getChildIntegerValue(String name, Integer defaultValue) {
            ConfigNode child = this.getChild(name);
            if (null == child) {
                return defaultValue;
            }
            return child.integerValue(defaultValue);
        }

        public Long getChildLongValue(String name, Long defaultValue) {
            ConfigNode child = this.getChild(name);
            if (null == child) {
                return defaultValue;
            }
            return child.longValue(defaultValue);
        }

        public Float getChildFloatValue(String name, Float defaultValue) {
            ConfigNode child = this.getChild(name);
            if (null == child) {
                return defaultValue;
            }
            return child.floatValue(defaultValue);
        }

        public Double getChildDoubleValue(String name, Double defaultValue) {
            ConfigNode child = this.getChild(name);
            if (null == child) {
                return defaultValue;
            }
            return child.doubleValue(defaultValue);
        }

        public List<String> getChildStringListValue(String name, List<String> defaultValue) {
            ConfigNode child = this.getChild(name);
            if (null == child) {
                return defaultValue;
            }
            return child.stringList(defaultValue);
        }

        public void clear() {
            this.mValue = null;
            this.mChildren.clear();
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("name", (Object)this.mName).append("value", this.mValue).toString();
        }
    }
}

