/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.email;

import com.ibm.neo.email.EmailException;
import com.ibm.neo.email.MailMessage;
import java.io.IOException;
import java.io.Writer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Properties;
import org.apache.commons.net.smtp.AuthenticatingSMTPClient;
import org.apache.commons.net.smtp.SMTPClient;
import org.apache.commons.net.smtp.SMTPReply;
import org.apache.commons.net.smtp.SimpleSMTPHeader;

public class Emailer {
    public static final String PROP_SMTP_HOST = "com.ibm.neo.feedback.smtp.host";
    private static final String SMTP_HOST_DEFAULT = "smtp.sendgrid.com";
    public static final String PROP_SMTP_SERVER_AUTH = "com.ibm.neo.feedback.smtp.auth";
    public static final String PROP_SMTP_SERVER_AUTH_DEFAULT = "true";
    public static final String PROP_SMTP_SERVER_USER = "com.ibm.neo.feedback.smtp.username";
    private static final String SMTP_SERVER_USER_DEFAULT = "marc.boudreau@ca.ibm.com";
    public static final String PROP_SMTP_SERVER_PASSWORD = "com.ibm.neo.feedback.smtp.password";
    private static final String SMTP_SERVER_PASSWORD_DEFAULT = "1qaz@WSX";
    public static final String PROP_TRANSMIT_EMAIL_MESSAGE = "com.ibm.neo.email.transmit-email";
    private static final String TRANSMIT_EMAIL_MESSAGE_DEFAULT = "true";
    private final boolean mTransmitMessage;
    private final String mHost;
    private final String mUsername;
    private final String mPassword;
    private final int mPort;
    private final String mAuth;

    public Emailer(Properties configuration) {
        if (configuration == null) {
            configuration = new Properties();
        }
        this.mTransmitMessage = Boolean.parseBoolean(configuration.getProperty(PROP_TRANSMIT_EMAIL_MESSAGE, "true"));
        this.mHost = configuration.getProperty(PROP_SMTP_HOST, SMTP_HOST_DEFAULT);
        this.mPort = 25;
        this.mUsername = configuration.getProperty(PROP_SMTP_SERVER_USER, SMTP_SERVER_USER_DEFAULT);
        this.mPassword = configuration.getProperty(PROP_SMTP_SERVER_PASSWORD, SMTP_SERVER_PASSWORD_DEFAULT);
        this.mAuth = configuration.getProperty(PROP_SMTP_SERVER_AUTH, "true");
    }

    public void send(MailMessage message) throws EmailException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        SMTPClient client = this.open();
        client.setSender(message.getFromAddress());
        for (String address : message.getToAddresses()) {
            client.addRecipient(address);
        }
        Writer w = client.sendMessageData();
        if (w == null) {
            throw new EmailException("Server rejected");
        }
        for (String toAddress : message.getToAddresses()) {
            SimpleSMTPHeader header = new SimpleSMTPHeader(message.getFromAddress(), toAddress, message.getSubject());
            if (message.getHtmlBody() != null) {
                header.addHeaderField("text/html", message.getHtmlBody());
            }
            if (message.getPlainTextBody() != null) {
                header.addHeaderField("text/plain", message.getPlainTextBody());
            }
            w.write(header.toString());
            w.flush();
        }
        w.close();
        client.completePendingCommand();
        client.logout();
        client.disconnect();
    }

    private SMTPClient open() throws EmailException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        AuthenticatingSMTPClient client = new AuthenticatingSMTPClient("UTF-8");
        try {
            client.connect(this.mHost, this.mPort);
            if (!SMTPReply.isPositiveCompletion((int)client.getReplyCode())) {
                throw new EmailException("Connect to server failed" + client.getReplyString());
            }
            if (!client.login()) {
                throw new EmailException("Server rejected login: " + client.getReplyString());
            }
            if (!client.auth(AuthenticatingSMTPClient.AUTH_METHOD.CRAM_MD5, this.mUsername, this.mPassword)) {
                throw new EmailException("Authentication failed: " + client.getReplyString());
            }
        }
        catch (IOException e) {
            if (client.isConnected()) {
                try {
                    client.disconnect();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            throw new EmailException(e.getMessage(), e);
        }
        catch (EmailException e) {
            if (client.isConnected()) {
                try {
                    client.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
        return client;
    }
}

