/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.event;

import com.ibm.neo.util.Assertions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class EventSupport<T> {
    private final Class<T> listenerType;
    private final Collection<T> targets = new ConcurrentLinkedQueue<T>();
    private final T proxyInstance;
    private boolean enabled = true;
    private boolean traceInvoke = false;

    private EventSupport(Class<T> inListenerType) {
        Assertions.assertNotNull(inListenerType);
        this.listenerType = inListenerType;
        ClassLoader loader = this.listenerType.getClassLoader();
        Class[] interfaces = new Class[]{this.listenerType};
        this.proxyInstance = Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)new MulticastHandler());
    }

    public static <L> EventSupport<L> create(Class<L> inListenerClass) {
        return new EventSupport<L>(inListenerClass);
    }

    public T getFiringProxy() {
        assert (null != this.proxyInstance);
        return this.proxyInstance;
    }

    private void checkListener(Object listener) {
        Assertions.assertTrue(this.listenerType.isInstance(listener), "Listener parameter type does not match typepassed into constructor");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean newEnabled) {
        this.enabled = newEnabled;
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void add(T listener) {
        Assertions.assertNotNull(listener);
        this.checkListener(listener);
        if (this.targets.contains(listener)) {
            return;
        }
        this.targets.add(listener);
    }

    public void remove(T listener) {
        if (null != listener) {
            this.checkListener(listener);
        }
        this.targets.remove(listener);
    }

    public void clear() {
        this.targets.clear();
    }

    public Iterator<T> unmodifiableListenerIterator() {
        final Iterator<T> delegate = this.targets.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public T next() {
                return delegate.next();
            }

            @Override
            public void remove() {
            }
        };
    }

    public int countListeners() {
        return this.targets.size();
    }

    public T[] getListeners() {
        return this.targets.toArray((Object[])Array.newInstance(this.listenerType, this.targets.size()));
    }

    public void dumpListeners() {
        StringWriter dump = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)dump, true);
        writer.println("-------------------------------------------------");
        writer.println("Listeners of type: " + this.listenerType.getName());
        writer.println("-------------------------------------------------");
        T[] listeners = this.getListeners();
        for (int n = 0; n < listeners.length; ++n) {
            T listenerImpl = listeners[n];
            String name = listenerImpl.getClass().getName();
            writer.println(name + "@" + System.identityHashCode(listenerImpl));
        }
        writer.println("-------------------------------------------------");
        System.out.print(dump.toString());
    }

    public boolean getTraceInvoke() {
        return this.traceInvoke;
    }

    public void setTraceInvoke(boolean newTraceInvoke) {
        this.traceInvoke = newTraceInvoke;
    }

    private class MulticastHandler
    implements InvocationHandler {
        private MulticastHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object value = null;
            if (!EventSupport.this.enabled) {
                return null;
            }
            T[] listeners = EventSupport.this.getListeners();
            for (int n = 0; n < listeners.length; ++n) {
                try {
                    if (EventSupport.this.traceInvoke) {
                        System.out.println("EventSupport invoke on " + listeners[n] + " started for method " + method.getName());
                    }
                    long begin = System.currentTimeMillis();
                    value = method.invoke(listeners[n], args);
                    long elapsed = System.currentTimeMillis() - begin;
                    if (!EventSupport.this.traceInvoke) continue;
                    System.out.println("EventSupport invoke on " + listeners[n] + " completed took " + elapsed + "ms");
                    continue;
                }
                catch (UndeclaredThrowableException ute) {
                    throw ute.getCause();
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            return value;
        }
    }
}

