/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.exception;

import com.ibm.json.java.JSONObject;
import com.ibm.neo.util.JSONBuilder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class WatsonMessageContext {
    public static final String JSON_PROP_CONTEXT_ITEMS = "contextItems";
    public static final String JSON_PROP_ITEM_VALUE = "itemValue";
    public static final String JSON_PROP_ITEM_KEY = "itemKey";
    public static final String JSON_PROP_CONDITION_CODE = "conditionCode";
    private final Enum<?> m_conditionCode;
    private final HashMap<Enum<?>, Object> m_messageContext;

    public static Builder newBuilder() {
        return new Builder();
    }

    public WatsonMessageContext(Enum<?> _conditionCode) {
        this.m_conditionCode = _conditionCode;
        this.m_messageContext = new HashMap();
    }

    public Enum<?> getConditionCode() {
        return this.m_conditionCode;
    }

    public WatsonMessageContext putItem(Enum<?> _contextItemKey, Object _object) {
        this.m_messageContext.put(_contextItemKey, _object);
        return this;
    }

    public WatsonMessageContext putItemIfNotNull(Enum<?> _contextItemKey, Object _object) {
        if (_object != null) {
            this.m_messageContext.put(_contextItemKey, _object);
        }
        return this;
    }

    public <T> T getItem(Enum<?> _contextItemKey, Class<T> _class) {
        Object item = this.m_messageContext.get(_contextItemKey);
        if (item == null) {
            return null;
        }
        return (T)item;
    }

    public Iterator<Enum<?>> getItemKeyIterator() {
        return this.m_messageContext.keySet().iterator();
    }

    public void assign(WatsonMessageContext _messageContext, boolean _merge) {
        if (!_merge) {
            this.m_messageContext.clear();
        }
        Iterator<Enum<?>> it = _messageContext.getItemKeyIterator();
        while (it.hasNext()) {
            Enum<?> key = it.next();
            this.m_messageContext.put(key, _messageContext.getItem(key, Object.class));
        }
    }

    public JSONObject toJSON() {
        JSONObject context = new JSONObject();
        for (Enum<?> key : this.m_messageContext.keySet()) {
            context.put((Object)key.toString(), this.m_messageContext.get(key));
        }
        JSONObject ret = JSONBuilder.ob(JSONBuilder.pr(JSON_PROP_CONDITION_CODE, this.m_conditionCode.toString()), JSONBuilder.pr(JSON_PROP_CONTEXT_ITEMS, context));
        return ret;
    }

    public static final class Builder {
        private Enum<?> mConditionCode = null;
        private HashMap<Enum<?>, Object> mContextData = new HashMap();

        private Builder() {
        }

        public Builder withConditionCode(Enum<?> conditionCode) {
            this.mConditionCode = conditionCode;
            return this;
        }

        public Builder withContextItem(Enum<?> key, Object value) {
            this.mContextData.put(key, value);
            return this;
        }

        public WatsonMessageContext build() {
            WatsonMessageContext messageContext = new WatsonMessageContext(this.mConditionCode);
            for (Map.Entry<Enum<?>, Object> e : this.mContextData.entrySet()) {
                messageContext.putItem(e.getKey(), e.getValue());
            }
            return messageContext;
        }
    }
}

