/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.exception;

import com.ibm.json.java.JSONObject;
import com.ibm.neo.exception.IWatsonError;
import com.ibm.neo.exception.WatsonMessageContext;
import com.ibm.neo.util.JSONBuilder;

public abstract class WatsonRuntimeException
extends RuntimeException
implements IWatsonError {
    public static final String JSON_PROP_CONTEXT = "context";
    public static final String JSON_PROP_CAUSE = "cause";
    public static final String JSON_PROP_MESSAGE = "message";
    private static final long serialVersionUID = 3153420369152828796L;
    private final WatsonMessageContext m_errorContext;

    public WatsonRuntimeException(String _message, Throwable _cause, WatsonMessageContext _messageContext) {
        super(_message, _cause);
        this.m_errorContext = _messageContext;
    }

    @Override
    public WatsonMessageContext getWatsonMessageContext() {
        return this.m_errorContext;
    }

    @Override
    public JSONObject toJSON() {
        return WatsonRuntimeException.throwableToJSON(this);
    }

    public static JSONObject throwableToJSON(Throwable _throwable) {
        WatsonMessageContext context;
        Throwable cause = _throwable.getCause();
        JSONObject ret = JSONBuilder.ob(JSONBuilder.pr(JSON_PROP_MESSAGE, _throwable.getMessage()), JSONBuilder.pr(JSON_PROP_CAUSE, cause == null ? null : WatsonRuntimeException.throwableToJSON(cause)));
        if (_throwable instanceof IWatsonError && (context = ((IWatsonError)((Object)_throwable)).getWatsonMessageContext()) != null && context.getConditionCode() != null) {
            ret.put((Object)JSON_PROP_CONTEXT, (Object)context.toJSON());
        }
        return ret;
    }
}

