/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.g11n;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class CustomEncodingResourceBundleControl
extends ResourceBundle.Control {
    public static final CustomEncodingResourceBundleControl UTF8_RESOURCE_BUNDLE_CONTROL = new CustomEncodingResourceBundleControl("UTF-8");
    private String encoding;

    public CustomEncodingResourceBundleControl(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        String bundleName = this.toBundleName(baseName, locale);
        ResourceBundle bundle = null;
        if (format.equals("java.class")) {
            bundle = this.javaClassFormatNewBundle(loader, bundleName, bundle);
        } else if (format.equals("java.properties")) {
            bundle = this.javaPropertiesFormatNewBundle(bundleName, bundle, loader, reload);
        } else {
            throw new IllegalArgumentException("unknown format: " + format);
        }
        return bundle;
    }

    private ResourceBundle javaClassFormatNewBundle(ClassLoader loader, String bundleName, ResourceBundle bundle) throws InstantiationException, IllegalAccessException {
        try {
            Class<?> bundleClass = loader.loadClass(bundleName);
            if (!ResourceBundle.class.isAssignableFrom(bundleClass)) {
                throw new ClassCastException(bundleClass.getName() + " cannot be cast to ResourceBundle");
            }
            bundle = (ResourceBundle)bundleClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle javaPropertiesFormatNewBundle(String bundleName, ResourceBundle bundle, ClassLoader loader, boolean reload) throws IOException {
        String resourceName = this.toResourceName(bundleName, "properties");
        if (resourceName == null) {
            return bundle;
        }
        ClassLoader classLoader = loader;
        boolean reloadFlag = reload;
        InputStream stream = null;
        try {
            stream = AccessController.doPrivileged(new InputStreamPrivilegedExceptionAction(reloadFlag, classLoader, resourceName));
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        if (stream != null) {
            try {
                bundle = new PropertyResourceBundle(new InputStreamReader(stream, this.encoding));
            }
            finally {
                stream.close();
            }
        }
        return bundle;
    }

    private static class InputStreamPrivilegedExceptionAction
    implements PrivilegedExceptionAction<InputStream> {
        private final boolean reloadFlag;
        private final ClassLoader classLoader;
        private final String resourceName;

        public InputStreamPrivilegedExceptionAction(boolean reloadFlag, ClassLoader classLoader, String resourceName) {
            this.reloadFlag = reloadFlag;
            this.classLoader = classLoader;
            this.resourceName = resourceName;
        }

        @Override
        public InputStream run() throws IOException {
            InputStream is = null;
            if (this.reloadFlag) {
                URLConnection connection;
                URL url = this.classLoader.getResource(this.resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    is = connection.getInputStream();
                }
            } else {
                is = this.classLoader.getResourceAsStream(this.resourceName);
            }
            return is;
        }
    }
}

