/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.g11n;

import com.ibm.neo.g11n.FixedLocaleProvider;
import com.ibm.neo.g11n.LocaleProvider;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public abstract class LocaleUtil {
    private static final Pattern LOCALE_STR_PAT = Pattern.compile("([a-zA-Z]{2,3})(?:[_-]([a-zA-Z]{2})(?:[_-](\\w*))?)?");
    private static LocaleProvider localProvider = new FixedLocaleProvider(new Locale("en", "US"));

    private LocaleUtil() {
    }

    public static void setLocaleProvider(LocaleProvider provider) {
        if (null == provider) {
            throw new NullPointerException("provider was null");
        }
        localProvider = provider;
    }

    public static Locale getProductLocale() {
        return localProvider.getProductLocale();
    }

    public static Locale localeFromString(String localeString) {
        if (StringUtils.isEmpty((String)localeString)) {
            return null;
        }
        Matcher m = LOCALE_STR_PAT.matcher(localeString);
        if (!m.matches()) {
            return null;
        }
        if (m.group(2) != null) {
            if (m.group(3) != null) {
                return new Locale(m.group(1), m.group(2), m.group(3));
            }
            return new Locale(m.group(1), m.group(2));
        }
        return new Locale(m.group(1));
    }
}

