/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.g11n;

import com.ibm.neo.g11n.CustomEncodingResourceBundleControl;
import com.ibm.neo.g11n.LocaleUtil;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class MessageUtil {
    private static final Locale DEFAULT_LOCALE = new Locale("en", "US");

    private MessageUtil() {
    }

    public static String getMessage(String bundle, String key, Object ... params) {
        return MessageUtil.getMessage(bundle, key, LocaleUtil.getProductLocale(), params);
    }

    public static String getMessage(String bundle, String key, Locale locale, Object ... params) {
        if (null == locale) {
            locale = DEFAULT_LOCALE;
        }
        try {
            String s = ResourceBundle.getBundle(bundle, locale, CustomEncodingResourceBundleControl.UTF8_RESOURCE_BUNDLE_CONTROL).getString(key);
            if (params.length > 0) {
                s = MessageFormat.format(s, params);
            }
            return s;
        }
        catch (MissingResourceException e) {
            return "[Missing key:" + key + "]";
        }
    }
}

