/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import com.ibm.neo.util.Filter;
import com.ibm.neo.util.Mutator;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.NullArgumentException;

public class ArchiveUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tarDirectory(File tarFile, File dirFile) throws IOException {
        if (null == tarFile) {
            throw new NullArgumentException("tarFile");
        }
        if (null != tarFile.getParentFile()) {
            FileUtils.forceMkdir((File)tarFile.getParentFile());
        }
        FileOutputStream fos = new FileOutputStream(tarFile);
        boolean success = false;
        try {
            ArchiveUtils.tarDirectory(fos, dirFile);
            success = true;
        }
        finally {
            fos.close();
            if (!success) {
                tarFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tarDirectory(OutputStream out, File dirFile) throws IOException {
        if (null == out) {
            throw new NullArgumentException("out");
        }
        if (null == dirFile) {
            throw new NullArgumentException("dirFile");
        }
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            throw new IllegalArgumentException("Invalid directory: " + dirFile.getPath());
        }
        TarArchiveOutputStream tos = new TarArchiveOutputStream(out);
        boolean success = false;
        try {
            tos.setBigNumberMode(2);
            tos.setLongFileMode(3);
            File[] children = dirFile.listFiles();
            if (null != children) {
                for (File child : children) {
                    ArchiveUtils.addToArchive((ArchiveOutputStream)tos, child, "");
                }
            }
            success = true;
        }
        finally {
            if (success) {
                tos.close();
            } else {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void untarDirectory(File tarFile, File dirFile) throws IOException {
        if (null == tarFile) {
            throw new NullArgumentException("tarFile");
        }
        try (FileInputStream fis = new FileInputStream(tarFile);){
            ArchiveUtils.untarDirectory(fis, dirFile);
        }
    }

    public static void untarDirectory(InputStream in, File dirFile) throws IOException {
        ArchiveUtils.untarDirectory(in, dirFile, new Filter<ArchiveEntry>(){

            @Override
            public boolean accept(ArchiveEntry value) {
                return true;
            }
        }, new Mutator<String>(){

            @Override
            public String mutate(String value) {
                return value;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void untarDirectory(InputStream in, File dirFile, Filter<ArchiveEntry> filter, Mutator<String> nameChanger) throws IOException {
        if (null == in) {
            throw new NullArgumentException("in");
        }
        if (null == dirFile) {
            throw new NullArgumentException("dirFile");
        }
        if (!dirFile.exists()) {
            FileUtils.forceMkdir((File)dirFile);
        }
        try (TarArchiveInputStream tis = new TarArchiveInputStream(in);){
            ArchiveEntry entry = tis.getNextEntry();
            while (null != entry && filter.accept(entry)) {
                String name = nameChanger.mutate(entry.getName());
                File f = new File(FilenameUtils.concat((String)dirFile.getAbsolutePath(), (String)name));
                if (entry.isDirectory()) {
                    FileUtils.forceMkdir((File)f);
                } else {
                    try (FileOutputStream fos = new FileOutputStream(f);){
                        int numBytesRead;
                        byte[] buf = new byte[(int)Math.min(entry.getSize(), 8092L)];
                        for (long numBytesLeft = entry.getSize(); numBytesLeft > 0L; numBytesLeft -= (long)numBytesRead) {
                            numBytesRead = tis.read(buf, 0, (int)Math.min(numBytesLeft, (long)buf.length));
                            if (numBytesRead < 0) {
                                throw new EOFException("unexpected end of stream");
                            }
                            fos.write(buf, 0, numBytesRead);
                        }
                    }
                }
                entry = tis.getNextEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToArchive(ArchiveOutputStream aos, File file, String basePath) throws IOException {
        block13: {
            String entryName = basePath + file.getName();
            ArchiveEntry entry = aos.createArchiveEntry(file, entryName);
            aos.putArchiveEntry(entry);
            if (file.isFile()) {
                try (FileInputStream fin = new FileInputStream(file);){
                    IOUtils.copy((InputStream)fin, (OutputStream)aos);
                    break block13;
                }
                finally {
                    try {
                        aos.closeArchiveEntry();
                    }
                    catch (Exception ex) {}
                }
            }
            aos.closeArchiveEntry();
            File[] children = file.listFiles();
            if (null != children) {
                for (File child : children) {
                    ArchiveUtils.addToArchive(aos, child, entryName + "/");
                }
            }
        }
    }
}

