/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import java.io.IOException;
import java.io.InputStream;

public final class BOMDetector {
    public static final BOM BOM_UTF_8 = new BOM("UTF-8", new byte[]{-17, -69, -65});
    public static final BOM BOM_UTF_16_LE = new BOM("UTF-16LE", new byte[]{-1, -2});
    public static final BOM BOM_UTF_16_BE = new BOM("UTF-16BE", new byte[]{-2, -1});
    public static final BOM BOM_UTF_32_LE = new BOM("UTF-32LE", new byte[]{-1, -2, 0, 0});
    public static final BOM BOM_UTF_32_BE = new BOM("UTF-32BE", new byte[]{0, 0, -2, -1});
    public static final BOM BOM_GB18030 = new BOM("GB18030", new byte[]{-124, 49, -107, 51});
    private static final BOM[] ALL_BOMS = new BOM[]{BOM_UTF_32_LE, BOM_UTF_32_BE, BOM_GB18030, BOM_UTF_8, BOM_UTF_16_LE, BOM_UTF_16_BE};

    private BOMDetector() {
    }

    public static BOM detect(byte[] data) {
        for (BOM b : ALL_BOMS) {
            if (!b.matches(data)) continue;
            return b;
        }
        return null;
    }

    public static BOM detect(InputStream stream) throws IOException {
        if (!stream.markSupported()) {
            throw new RuntimeException("Mark is not supported by InputStream.");
        }
        byte[] sample = new byte[4];
        stream.mark(4);
        if (!BOMDetector.readAll(stream, sample, 4)) {
            return null;
        }
        stream.reset();
        return BOMDetector.detect(sample);
    }

    private static boolean readAll(InputStream stream, byte[] buffer, int length) throws IOException {
        int len;
        int offset = 0;
        for (int bytesToRead = length; bytesToRead > 0; bytesToRead -= len) {
            len = stream.read(buffer, offset, bytesToRead);
            if (len < 0) {
                return false;
            }
            offset += len;
        }
        return true;
    }

    public static final class BOM {
        private final String mCharsetName;
        private final byte[] mSignature;

        private BOM(String charsetName, byte[] signature) {
            this.mCharsetName = charsetName;
            this.mSignature = signature;
        }

        public String getCharsetName() {
            return this.mCharsetName;
        }

        public int getByteLength() {
            return this.mSignature.length;
        }

        public boolean matches(byte[] data) {
            if (this.mSignature.length > data.length) {
                return false;
            }
            for (int i = 0; i < this.mSignature.length; ++i) {
                if (this.mSignature[i] == data[i]) continue;
                return false;
            }
            return true;
        }
    }
}

