/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private static final int BYTE_MASK32 = 255;
    private final ByteBuffer mBuffer;
    private volatile boolean mClosed = false;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.mBuffer = buffer;
    }

    @Override
    public int read() throws IOException {
        this.checkIfClosed();
        if (this.mBuffer.hasRemaining()) {
            return this.mBuffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.checkIfClosed();
        if (this.mBuffer.hasRemaining()) {
            int numBytes = Math.min(len, this.mBuffer.remaining());
            this.mBuffer.get(b, off, numBytes);
            return numBytes;
        }
        return -1;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkIfClosed();
        if (n <= 0L) {
            return 0L;
        }
        int numSkipped = (int)Math.min(n, (long)this.mBuffer.remaining());
        this.mBuffer.position(this.mBuffer.position() + numSkipped);
        return numSkipped;
    }

    @Override
    public int available() throws IOException {
        this.checkIfClosed();
        return this.mBuffer.remaining();
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
    }

    private void checkIfClosed() throws IOException {
        if (this.mClosed) {
            throw new IOException("Stream is closed");
        }
    }
}

