/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private static final int DEFAULT_INITIAL_CAPACITY = 512;
    private ByteBuffer mBuffer;
    private volatile boolean mClosed = false;

    public ByteBufferOutputStream() {
        this(512);
    }

    public ByteBufferOutputStream(int initialCapacity) {
        this.mBuffer = ByteBuffer.allocate(initialCapacity);
    }

    @Override
    public void write(int b) throws IOException {
        this.checkIfClosed();
        this.ensureRemaining(1);
        this.mBuffer.put((byte)(b & 0xFF));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.checkIfClosed();
        this.ensureRemaining(len);
        this.mBuffer.put(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
    }

    public int size() {
        return this.mBuffer.capacity() - this.mBuffer.remaining();
    }

    public void reset() {
        this.mBuffer.clear();
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(this.size());
        this.transferTo(buffer);
        buffer.flip();
        return buffer;
    }

    public byte[] toByteArray() {
        byte[] array = new byte[this.size()];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        this.transferTo(buffer);
        buffer.flip();
        return array;
    }

    public int transferTo(ByteBuffer dest) {
        int oldPosition = this.mBuffer.position();
        int bytesToCopy = Math.min(this.mBuffer.position(), dest.remaining());
        this.mBuffer.position(0);
        this.mBuffer.limit(bytesToCopy);
        dest.put(this.mBuffer);
        this.mBuffer.limit(oldPosition);
        this.mBuffer.compact();
        return bytesToCopy;
    }

    private void ensureRemaining(int remaining) {
        if (this.mBuffer.remaining() < remaining) {
            int newCapacity = Math.max((int)Math.ceil((double)this.mBuffer.capacity() * 1.5), this.mBuffer.position() + remaining);
            ByteBuffer newBuf = ByteBuffer.allocate(newCapacity);
            this.mBuffer.flip();
            newBuf.put(this.mBuffer);
            this.mBuffer = newBuf;
        }
    }

    private void checkIfClosed() throws IOException {
        if (this.mClosed) {
            throw new IOException("Stream was closed");
        }
    }
}

