/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ByteBufferPool {
    private static final List<ByteBufferPool> SHARED_POOLS = new ArrayList<ByteBufferPool>();
    private final int mBufferSize;
    private final boolean mUseDirect;
    private final ByteOrder mMultiByteOrder;
    private final ConcurrentLinkedQueue<SoftReference<ByteBuffer>> mFreeQueue = new ConcurrentLinkedQueue();

    public static synchronized ByteBufferPool getSharedInstance(int bufferSize, ByteOrder multiByteOrder, boolean useDirect) {
        for (ByteBufferPool p : SHARED_POOLS) {
            if (p.getBufferSize() != bufferSize && p.getMultiByteOrder() != multiByteOrder && p.isDirect() != useDirect) continue;
            return p;
        }
        ByteBufferPool p = new ByteBufferPool(bufferSize, multiByteOrder, useDirect);
        SHARED_POOLS.add(p);
        return p;
    }

    public ByteBufferPool(int bufferSize, ByteOrder multiByteOrder, boolean useDirect) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize < 1");
        }
        this.mBufferSize = bufferSize;
        this.mMultiByteOrder = multiByteOrder;
        this.mUseDirect = useDirect;
    }

    public int getBufferSize() {
        return this.mBufferSize;
    }

    public ByteOrder getMultiByteOrder() {
        return this.mMultiByteOrder;
    }

    public boolean isDirect() {
        return this.mUseDirect;
    }

    public BufferSmartRef allocate() {
        SoftReference<ByteBuffer> bufRef = null;
        ByteBuffer buf = null;
        while (null == buf && null != (bufRef = this.mFreeQueue.poll())) {
            buf = bufRef.get();
        }
        if (null == buf) {
            buf = this.mUseDirect ? ByteBuffer.allocateDirect(this.mBufferSize) : ByteBuffer.allocate(this.mBufferSize);
        } else {
            buf.clear();
        }
        buf.order(this.mMultiByteOrder);
        return new BufferSmartRef(this, buf);
    }

    public void release(BufferSmartRef ref) {
        if (this != ref.getPool()) {
            throw new IllegalArgumentException("ref was not allocated from this pool");
        }
        ByteBuffer buf = ref.finishRelease();
        if (null != buf) {
            this.mFreeQueue.add(new SoftReference<ByteBuffer>(buf));
        }
    }

    public static final class BufferSmartRef {
        private final ByteBufferPool mPool;
        private final ByteBuffer mBuffer;
        private volatile boolean mReleased = false;

        public BufferSmartRef(ByteBufferPool pool, ByteBuffer buffer) {
            this.mPool = pool;
            this.mBuffer = buffer;
        }

        public ByteBufferPool getPool() {
            return this.mPool;
        }

        public ByteBuffer get() {
            if (this.mReleased) {
                throw new IllegalStateException("buffer was released");
            }
            return this.mBuffer;
        }

        protected void finalize() {
            this.release();
        }

        public void release() {
            if (!this.mReleased) {
                this.getPool().release(this);
            }
        }

        private ByteBuffer finishRelease() {
            if (!this.mReleased) {
                this.mReleased = true;
                return this.mBuffer;
            }
            return null;
        }
    }
}

