/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import com.ibm.neo.io.FastOutputStreamWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NullArgumentException;

public class CSVWriter {
    private final Writer mWriter;
    private final char mFieldSeparator;
    private final char[] mRecordSeparator;
    private final Character mEncapsulator;
    private final char[] mNullString;
    private final StringBuilder mRecordBuffer = new StringBuilder();

    public CSVWriter(File csvFile, char fieldSeparator, String recordSeparator, Character encapsulator, String nullString) throws FileNotFoundException {
        this(new FileOutputStream(csvFile), fieldSeparator, recordSeparator, encapsulator, nullString);
    }

    public CSVWriter(OutputStream os, char fieldSeparator, String recordSeparator, Character encapsulator, String nullString) {
        this(new FastOutputStreamWriter(os, "UTF-8"), fieldSeparator, recordSeparator, encapsulator, nullString);
    }

    public CSVWriter(Writer writer, char fieldSeparator, String recordSeparator, Character encapsulator, String nullString) {
        if (null == recordSeparator) {
            throw new NullArgumentException("recordSeparator");
        }
        if (recordSeparator.isEmpty()) {
            throw new IllegalArgumentException("recordSeparator was empty");
        }
        if (null == nullString) {
            throw new NullArgumentException("nullString");
        }
        this.mWriter = writer;
        this.mFieldSeparator = fieldSeparator;
        this.mRecordSeparator = recordSeparator.toCharArray();
        this.mEncapsulator = encapsulator;
        this.mNullString = nullString.toCharArray();
    }

    public void writeRecord(String[] fields) throws IOException {
        boolean first = true;
        this.mRecordBuffer.delete(0, this.mRecordBuffer.length());
        for (String field : fields) {
            if (first) {
                first = false;
            } else {
                this.mRecordBuffer.append(this.mFieldSeparator);
            }
            if (null == field) {
                this.mRecordBuffer.append(this.mNullString);
                continue;
            }
            this.appendWithEscapesAndEncapsulation(field);
        }
        this.mRecordBuffer.append(this.mRecordSeparator);
        this.mWriter.append(this.mRecordBuffer);
    }

    public void writeRecord(Object[] fields) throws IOException {
        boolean first = true;
        this.mRecordBuffer.delete(0, this.mRecordBuffer.length());
        for (Object field : fields) {
            if (first) {
                first = false;
            } else {
                this.mRecordBuffer.append(this.mFieldSeparator);
            }
            if (null == field) {
                this.mRecordBuffer.append(this.mNullString);
                continue;
            }
            this.appendWithEscapesAndEncapsulation(field.toString());
        }
        this.mRecordBuffer.append(this.mRecordSeparator);
        this.mWriter.append(this.mRecordBuffer);
    }

    private void appendWithEscapesAndEncapsulation(String str) throws IOException {
        int startPos = this.mRecordBuffer.length();
        boolean needsEncapsulation = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (null != this.mEncapsulator) {
                if (!needsEncapsulation) {
                    boolean bl = needsEncapsulation = c == this.mEncapsulator.charValue() || c == this.mFieldSeparator || ArrayUtils.contains((char[])this.mRecordSeparator, (char)c);
                }
                if (c == this.mEncapsulator.charValue()) {
                    this.mRecordBuffer.append(this.mEncapsulator.charValue()).append(this.mEncapsulator.charValue());
                    continue;
                }
                this.mRecordBuffer.append(c);
                continue;
            }
            this.mRecordBuffer.append(c);
        }
        if (needsEncapsulation) {
            this.mRecordBuffer.append(this.mEncapsulator.charValue());
            this.mRecordBuffer.insert(startPos, this.mEncapsulator.charValue());
        }
    }

    public void flush() throws IOException {
        this.mWriter.flush();
    }

    public void close() throws IOException {
        this.mWriter.close();
    }
}

