/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CancellationException;

public class CancellableInputStream
extends FilterInputStream {
    private volatile boolean mCancelled = false;

    public CancellableInputStream(InputStream in) {
        super(in);
    }

    public void cancel() {
        this.mCancelled = true;
    }

    public boolean isCancelled() {
        return this.mCancelled;
    }

    @Override
    public int read() throws IOException {
        this.assertNotCancelled();
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.assertNotCancelled();
        return super.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.assertNotCancelled();
        return super.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.assertNotCancelled();
        return super.skip(n);
    }

    private void assertNotCancelled() {
        if (this.mCancelled) {
            throw new CancellationException();
        }
    }
}

