/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ChannelInputStream
extends InputStream {
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private final ReadableByteChannel mChannel;
    private final ByteBuffer mBuffer;

    public ChannelInputStream(ReadableByteChannel channel) {
        this(channel, 32768);
    }

    public ChannelInputStream(ReadableByteChannel channel, int bufferSize) {
        this.mChannel = channel;
        this.mBuffer = ByteBuffer.allocate(bufferSize);
        this.mBuffer.flip();
    }

    @Override
    public int available() throws IOException {
        return this.mBuffer.remaining();
    }

    @Override
    public int read() throws IOException {
        if (!this.ensureBufferRemaining(1)) {
            return -1;
        }
        byte b = this.mBuffer.get();
        return b & 0xFF;
    }

    @Override
    public int read(byte[] buf, int start, int length) throws IOException {
        if (start < 0) {
            throw new IllegalArgumentException("start was negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length was negative");
        }
        if (length == 0) {
            return 0;
        }
        if (!this.ensureBufferRemaining(1)) {
            return -1;
        }
        int numToRead = Math.min(length, this.mBuffer.remaining());
        this.mBuffer.get(buf, start, numToRead);
        return numToRead;
    }

    @Override
    public void close() throws IOException {
        if (this.mChannel.isOpen()) {
            this.mChannel.close();
        }
    }

    private boolean ensureBufferRemaining(int minSize) throws IOException {
        if (minSize > this.mBuffer.capacity()) {
            throw new IllegalArgumentException("minSize > mBufferCapacity");
        }
        while (this.mBuffer.remaining() < minSize && this.fillBuffer() >= 0) {
        }
        return this.mBuffer.remaining() >= minSize;
    }

    private int fillBuffer() throws IOException {
        this.mBuffer.compact();
        int ret = this.mChannel.read(this.mBuffer);
        this.mBuffer.flip();
        return ret;
    }
}

