/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class ChannelOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private final WritableByteChannel mChannel;
    private final ByteBuffer mBuffer;

    public ChannelOutputStream(WritableByteChannel channel) {
        this(channel, 32768);
    }

    public ChannelOutputStream(WritableByteChannel channel, int bufferSize) {
        this.mChannel = channel;
        this.mBuffer = ByteBuffer.allocateDirect(bufferSize);
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureBufferRemaining(1);
        this.mBuffer.put((byte)(b & 0xFF));
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int start, int length) throws IOException {
        if (start < 0 || length < 0 || start + length > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        while (length > 0) {
            this.ensureBufferRemaining(1);
            int bytesToWrite = Math.min(this.mBuffer.remaining(), length);
            this.mBuffer.put(buf, start, bytesToWrite);
            start += bytesToWrite;
            length -= bytesToWrite;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.flushBuffer(true);
        }
        finally {
            this.mChannel.close();
        }
    }

    protected void ensureBufferRemaining(int minSize) throws IOException {
        while (this.mBuffer.remaining() < minSize) {
            this.flushBuffer(false);
        }
    }

    private void flushBuffer(boolean flushAll) throws IOException {
        this.mBuffer.flip();
        do {
            this.mChannel.write(this.mBuffer);
        } while (flushAll && this.mBuffer.hasRemaining());
        this.mBuffer.compact();
    }
}

