/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import com.ibm.neo.io.ByteBufferOutputStream;
import com.ibm.neo.io.CSVWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public abstract class CsvTransformInputStream
extends InputStream {
    private static final int BYTE_MASK32 = 255;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final ByteBuffer outputBuffer;
    private final ByteBufferOutputStream writerBuffer;
    private final CSVWriter writer;
    private boolean endOfInput = false;
    private boolean endOfOutput = false;
    private boolean closed = false;

    public CsvTransformInputStream(char fieldSeparator, String recordSeparator, Character encapsulator, String nullString) {
        this(fieldSeparator, recordSeparator, encapsulator, nullString, 8192);
    }

    public CsvTransformInputStream(char fieldSeparator, String recordSeparator, Character encapsulator, String nullString, int bufferSize) {
        this.outputBuffer = ByteBuffer.allocate(bufferSize);
        this.outputBuffer.position(this.outputBuffer.capacity());
        this.writerBuffer = new ByteBufferOutputStream(bufferSize);
        this.writer = new CSVWriter(this.writerBuffer, fieldSeparator, recordSeparator, encapsulator, nullString);
    }

    @Override
    public int available() throws IOException {
        this.checkIfClosed();
        return this.outputBuffer.remaining();
    }

    @Override
    public int read() throws IOException {
        this.checkIfClosed();
        while (!this.outputBuffer.hasRemaining() && this.fillOutput()) {
        }
        if (this.outputBuffer.hasRemaining()) {
            return this.outputBuffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        this.checkIfClosed();
        while (!this.outputBuffer.hasRemaining() && this.fillOutput()) {
        }
        if (this.outputBuffer.hasRemaining()) {
            len = Math.min(len, this.outputBuffer.remaining());
            this.outputBuffer.get(buf, off, len);
            return len;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    private void checkIfClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream was closed");
        }
    }

    private boolean fillOutput() throws IOException {
        if (this.endOfOutput) {
            return false;
        }
        this.outputBuffer.compact();
        if (this.writerBuffer.size() > 0) {
            this.writerBuffer.transferTo(this.outputBuffer);
        }
        while (!this.endOfInput && this.outputBuffer.hasRemaining()) {
            String[] record = this.nextRecord();
            if (null == record) {
                this.endOfInput = true;
                this.writer.flush();
            } else {
                this.writer.writeRecord(record);
            }
            this.writerBuffer.transferTo(this.outputBuffer);
        }
        this.outputBuffer.flip();
        if (this.outputBuffer.hasRemaining()) {
            return true;
        }
        this.endOfOutput = true;
        return false;
    }

    protected abstract String[] nextRecord() throws IOException;
}

