/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import com.ibm.neo.io.FastCharBuffer;
import com.ibm.neo.io.LineOverflowException;
import java.io.IOException;
import java.io.Reader;

public class FastBufferedReader
extends Reader {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final Reader mSource;
    private final StringBuilder mLineBuilder = new StringBuilder(80);
    private FastCharBuffer mBuffer;
    private boolean mClosed = false;
    private boolean mEndOfStream = false;
    private boolean mMarked = false;

    public FastBufferedReader(Reader in, int sz) {
        super((Object)in);
        this.mSource = in;
        this.mBuffer = FastCharBuffer.allocate(sz);
        this.mBuffer.flip();
    }

    public FastBufferedReader(Reader in) {
        this(in, 8192);
    }

    private void checkIfClosed() throws IOException {
        if (this.mClosed) {
            throw new IOException("Stream closed");
        }
    }

    private boolean fill() throws IOException {
        int oldPos = this.mBuffer.position();
        int oldLimit = this.mBuffer.limit();
        if (oldLimit == this.mBuffer.capacity()) {
            this.mMarked = false;
        }
        if (!this.mEndOfStream) {
            if (this.mMarked) {
                this.mBuffer.position(oldLimit);
                this.mBuffer.limit(this.mBuffer.capacity());
                int len = this.mBuffer.write(this.mSource);
                if (len < 0) {
                    this.mBuffer.position(oldPos);
                    this.mBuffer.limit(oldLimit);
                    this.mEndOfStream = true;
                } else {
                    this.mBuffer.limit(this.mBuffer.position());
                    this.mBuffer.position(oldPos);
                }
            } else {
                this.mBuffer.compact();
                int len = this.mBuffer.write(this.mSource);
                if (len < 0) {
                    this.mBuffer.position(oldPos);
                    this.mBuffer.limit(oldLimit);
                    this.mEndOfStream = true;
                } else {
                    this.mBuffer.flip();
                }
            }
        }
        return this.mBuffer.hasRemaining();
    }

    @Override
    public int read() throws IOException {
        this.checkIfClosed();
        if (!this.mBuffer.hasRemaining() && !this.fill()) {
            return -1;
        }
        return this.mBuffer.get();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.checkIfClosed();
        if (!this.mBuffer.hasRemaining() && !this.fill()) {
            return -1;
        }
        len = Math.min(len, this.mBuffer.remaining());
        this.mBuffer.get(cbuf, off, len);
        return len;
    }

    public String readLine() throws IOException {
        this.checkIfClosed();
        this.mLineBuilder.setLength(0);
        boolean foundEOL = false;
        String line = null;
        while (!foundEOL) {
            if (!this.mBuffer.hasRemaining() && !this.fill()) {
                if (this.mLineBuilder.length() <= 0) break;
                line = this.mLineBuilder.toString();
                break;
            }
            int eolPos = this.mBuffer.find('\n', '\r');
            if (-1 == eolPos) {
                this.mBuffer.read(this.mLineBuilder);
                continue;
            }
            foundEOL = true;
            int len = eolPos - this.mBuffer.position();
            if (this.mLineBuilder.length() == 0) {
                line = this.mBuffer.getString(len);
            } else {
                this.mBuffer.read(this.mLineBuilder, len);
                line = this.mLineBuilder.toString();
            }
            this.mBuffer.advance(1);
            char chr = this.mBuffer.get(eolPos);
            if (chr != '\r' || !this.mBuffer.hasRemaining() || this.mBuffer.get(eolPos + 1) != '\n') continue;
            this.mBuffer.advance(1);
        }
        return line;
    }

    public String readLine(int maxChars) throws IOException {
        this.checkIfClosed();
        this.mLineBuilder.setLength(0);
        boolean foundEOL = false;
        String line = null;
        while (!foundEOL) {
            if (!this.mBuffer.hasRemaining() && !this.fill()) {
                if (this.mLineBuilder.length() <= 0) break;
                line = this.mLineBuilder.toString();
                break;
            }
            int eolPos = this.mBuffer.find('\n', '\r');
            if (-1 == eolPos) {
                if (this.mLineBuilder.length() + this.mBuffer.remaining() > maxChars) {
                    throw new LineOverflowException(maxChars);
                }
                this.mBuffer.read(this.mLineBuilder);
                continue;
            }
            foundEOL = true;
            int len = eolPos - this.mBuffer.position();
            if (this.mLineBuilder.length() + len > maxChars) {
                throw new LineOverflowException(maxChars);
            }
            if (this.mLineBuilder.length() == 0) {
                line = this.mBuffer.getString(len);
            } else {
                this.mBuffer.read(this.mLineBuilder, len);
                line = this.mLineBuilder.toString();
            }
            this.mBuffer.advance(1);
            char chr = this.mBuffer.get(eolPos);
            if (chr != '\r' || !this.mBuffer.hasRemaining() || this.mBuffer.get(eolPos + 1) != '\n') continue;
            this.mBuffer.advance(1);
        }
        return line;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkIfClosed();
        if (n < 0L) {
            throw new IllegalArgumentException("n < 0");
        }
        long skipped = 0L;
        while (n > 0L && (this.mBuffer.hasRemaining() || this.fill())) {
            int jump = (int)Math.min(n, (long)this.mBuffer.remaining());
            this.mBuffer.advance(jump);
            n -= (long)jump;
            skipped += (long)jump;
        }
        return skipped;
    }

    @Override
    public boolean ready() throws IOException {
        this.checkIfClosed();
        return !this.mEndOfStream && (this.mBuffer.hasRemaining() || this.mSource.ready());
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.checkIfClosed();
        this.mBuffer.compact();
        this.mBuffer.flip();
        if (readAheadLimit > this.mBuffer.capacity()) {
            FastCharBuffer newBuffer = FastCharBuffer.allocate(readAheadLimit);
            newBuffer.put(this.mBuffer);
            newBuffer.flip();
            this.mBuffer = newBuffer;
        }
        this.mMarked = true;
    }

    @Override
    public void reset() throws IOException {
        this.checkIfClosed();
        if (!this.mMarked) {
            throw new IOException("Mark invalid");
        }
        this.mMarked = false;
        this.mBuffer.position(0);
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        this.mSource.close();
    }
}

