/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import com.ibm.neo.io.FastCharBuffer;
import java.io.IOException;
import java.io.Writer;

public class FastBufferedWriter
extends Writer {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final Writer mSink;
    private final FastCharBuffer mBuffer;
    private boolean mClosed = false;

    public FastBufferedWriter(Writer sink) {
        this(sink, 8192);
    }

    public FastBufferedWriter(Writer sink, int bufferSize) {
        this.mSink = sink;
        this.mBuffer = FastCharBuffer.allocate(bufferSize);
        this.mBuffer.flip();
    }

    @Override
    public void write(int c) throws IOException {
        this.checkIfClosed();
        if (!this.mBuffer.hasRemaining()) {
            this.doFlush();
        }
        this.mBuffer.put((char)c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.checkIfClosed();
        while (len > 0) {
            if (!this.mBuffer.hasRemaining()) {
                this.doFlush();
            }
            int n = Math.min(this.mBuffer.remaining(), len);
            this.mBuffer.put(cbuf, off, n);
            off += n;
            len -= n;
        }
    }

    @Override
    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.checkIfClosed();
        while (len > 0) {
            if (!this.mBuffer.hasRemaining()) {
                this.doFlush();
            }
            int n = Math.min(this.mBuffer.remaining(), len);
            this.mBuffer.put(str, off, off + n);
            off += n;
            len -= n;
        }
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        String str = csq == null ? "null" : csq.toString();
        this.write(str, 0, str.length());
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        String str = csq == null ? "null" : csq.subSequence(start, end).toString();
        this.write(str, 0, str.length());
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.checkIfClosed();
        this.doFlush();
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            this.mClosed = true;
            this.doFlush();
        }
    }

    private void checkIfClosed() throws IOException {
        if (this.mClosed) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFlush() throws IOException {
        this.mBuffer.flip();
        try {
            this.mBuffer.read(this.mSink);
        }
        finally {
            this.mBuffer.compact();
        }
    }
}

