/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;

public class FastInputStreamReader
extends Reader {
    private final InputStream mInput;
    private final CharsetDecoder mDecoder;
    private final ByteBuffer mInputBuf = ByteBuffer.wrap(new byte[8192]);
    private final CharBuffer mOutputBuf = CharBuffer.wrap(new char[4096]);
    private boolean mEndOfInput = false;
    private boolean mEndOfOutput = false;
    private volatile boolean mClosed = false;

    public FastInputStreamReader(InputStream in) {
        this(in, Charset.defaultCharset());
    }

    public FastInputStreamReader(InputStream in, String charsetName) {
        this.mInput = in;
        this.mDecoder = Charset.forName(charsetName).newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.mInputBuf.position(this.mInputBuf.capacity());
        this.mOutputBuf.position(this.mOutputBuf.capacity());
    }

    public FastInputStreamReader(InputStream in, Charset charset) {
        this.mInput = in;
        this.mDecoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.mInputBuf.position(this.mInputBuf.capacity());
        this.mOutputBuf.position(this.mOutputBuf.capacity());
    }

    @Override
    public int read() throws IOException {
        this.checkIfClosed();
        while (!this.mOutputBuf.hasRemaining() && this.fillOutput()) {
        }
        if (this.mOutputBuf.hasRemaining()) {
            return this.mOutputBuf.get();
        }
        return -1;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.checkIfClosed();
        while (!this.mOutputBuf.hasRemaining() && this.fillOutput()) {
        }
        if (this.mOutputBuf.hasRemaining()) {
            len = Math.min(len, this.mOutputBuf.remaining());
            this.mOutputBuf.get(cbuf, off, len);
            return len;
        }
        return -1;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        this.checkIfClosed();
        while (!this.mOutputBuf.hasRemaining() && this.fillOutput()) {
        }
        if (this.mOutputBuf.hasRemaining()) {
            int len = Math.min(target.remaining(), this.mOutputBuf.remaining());
            target.put(this.mOutputBuf.array(), this.mOutputBuf.position(), len);
            this.mOutputBuf.position(this.mOutputBuf.position() + len);
            return len;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            this.mClosed = true;
            this.mInput.close();
        }
    }

    private void checkIfClosed() throws IOException {
        if (this.mClosed) {
            throw new IOException("Reader was closed");
        }
    }

    private boolean fillOutput() throws IOException {
        if (this.mEndOfOutput) {
            return false;
        }
        this.mOutputBuf.compact();
        if (this.fillInput()) {
            this.mDecoder.decode(this.mInputBuf, this.mOutputBuf, false);
            this.mOutputBuf.flip();
            return true;
        }
        this.mDecoder.decode(this.mInputBuf, this.mOutputBuf, true);
        this.mDecoder.flush(this.mOutputBuf);
        this.mOutputBuf.flip();
        this.mEndOfOutput = true;
        return false;
    }

    private boolean fillInput() throws IOException {
        if (this.mEndOfInput) {
            return false;
        }
        this.mInputBuf.compact();
        int numRead = this.mInput.read(this.mInputBuf.array(), this.mInputBuf.position(), this.mInputBuf.remaining());
        if (-1 == numRead) {
            this.mInputBuf.limit(this.mInputBuf.position());
            this.mInputBuf.position(0);
            this.mEndOfInput = true;
            return false;
        }
        this.mInputBuf.limit(this.mInputBuf.position() + numRead);
        this.mInputBuf.position(0);
        return true;
    }
}

