/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class FastOutputStreamWriter
extends Writer {
    private final OutputStream mOutput;
    private final CharsetEncoder mEncoder;
    private final CharBuffer mInputBuf = CharBuffer.wrap(new char[4096]);
    private final ByteBuffer mOutputBuf = ByteBuffer.wrap(new byte[8192]);
    private final char[] mTempBuf = new char[4096];
    private volatile boolean mClosed = false;

    public FastOutputStreamWriter(OutputStream output) {
        this(output, Charset.defaultCharset());
    }

    public FastOutputStreamWriter(OutputStream output, String charsetName) {
        this(output, Charset.forName(charsetName));
    }

    public FastOutputStreamWriter(OutputStream output, Charset charset) {
        this.mOutput = output;
        this.mEncoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    @Override
    public void write(int c) throws IOException {
        this.checkIfClosed();
        if (!this.mInputBuf.hasRemaining()) {
            this.doFlushInput(false);
        }
        this.mInputBuf.put((char)c);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.checkIfClosed();
        while (len > 0) {
            if (!this.mInputBuf.hasRemaining()) {
                this.doFlushInput(false);
            }
            int n = Math.min(len, this.mInputBuf.remaining());
            this.mInputBuf.put(cbuf, off, n);
            off += n;
            len -= n;
        }
    }

    @Override
    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.checkIfClosed();
        while (len > 0) {
            if (!this.mInputBuf.hasRemaining()) {
                this.doFlushInput(false);
            }
            int n = Math.min(len, this.mInputBuf.remaining());
            int pos = this.mInputBuf.position();
            str.getChars(off, off + n, this.mTempBuf, 0);
            System.arraycopy(this.mTempBuf, 0, this.mInputBuf.array(), pos, n);
            this.mInputBuf.position(pos + n);
            off += n;
            len -= n;
        }
    }

    @Override
    public Writer append(char c) throws IOException {
        this.write(c);
        return this;
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        String str = csq == null ? "null" : csq.toString();
        this.write(str, 0, str.length());
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        String str = csq == null ? "null" : csq.subSequence(start, end).toString();
        this.write(str, 0, str.length());
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.checkIfClosed();
        this.doFlushInput(true);
        this.doFlushOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            this.mClosed = true;
            try {
                this.doFlushInput(true);
                this.doFlushOutput();
            }
            finally {
                this.mOutput.close();
            }
        }
    }

    private void checkIfClosed() throws IOException {
        if (this.mClosed) {
            throw new IOException("Writer was closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFlushInput(boolean allOfIt) throws IOException {
        this.mInputBuf.flip();
        try {
            while (this.mInputBuf.hasRemaining()) {
                CoderResult result = this.mEncoder.encode(this.mInputBuf, this.mOutputBuf, this.mClosed);
                if (result.isOverflow()) {
                    this.doFlushOutput();
                    continue;
                }
                if (allOfIt) continue;
                break;
            }
        }
        finally {
            this.mInputBuf.compact();
        }
    }

    private void doFlushOutput() throws IOException {
        this.mOutputBuf.flip();
        this.mOutput.write(this.mOutputBuf.array(), 0, this.mOutputBuf.remaining());
        this.mOutputBuf.clear();
    }
}

