/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import java.text.DecimalFormat;

public class FileSizeUtils {
    private FileSizeUtils() {
    }

    public static String byteCountToHumanReadableString(long byteCount) {
        if (byteCount >= 0x10000000000L) {
            return new DecimalFormat("#.##").format((double)byteCount / 1.099511627776E12) + "TB";
        }
        if (byteCount >= 0x40000000L) {
            return new DecimalFormat("#.##").format((double)byteCount / 1.073741824E9) + "GB";
        }
        if (byteCount >= 0x100000L) {
            return new DecimalFormat("#.##").format((double)byteCount / 1048576.0) + "MB";
        }
        if (byteCount >= 1024L) {
            return new DecimalFormat("#").format((double)byteCount / 1024.0) + "KB";
        }
        return String.format("%dB", byteCount);
    }
}

