/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import com.ibm.neo.io.ByteBufferOutputStream;
import com.ibm.neo.io.TransformingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;

public class GzipCompressingInputStream
extends TransformingInputStream {
    private static final int INPUT_BUFFER_SIZE = 65536;
    private static final int OUTPUT_BUFFER_SIZE = 32768;

    public GzipCompressingInputStream(InputStream in) throws IOException {
        super(in, new GzipCompressor(), 65536, 32768);
    }

    private static final class GzipCompressor
    implements TransformingInputStream.ITransformer {
        private final ByteBufferOutputStream mBufOut = new ByteBufferOutputStream(8192);
        private final GzipCompressorOutputStream mGzipOut;
        private final byte[] mCopyBuf = new byte[8192];
        private boolean mFinished = false;

        private GzipCompressor() throws IOException {
            this.mGzipOut = new GzipCompressorOutputStream((OutputStream)this.mBufOut);
        }

        @Override
        public TransformingInputStream.ETransformResult transform(ByteBuffer input, ByteBuffer output, boolean endOfInput) throws IOException {
            if (!output.hasRemaining()) {
                return TransformingInputStream.ETransformResult.OVERFLOW;
            }
            int bytesToCopy = Math.min(this.mCopyBuf.length, input.remaining());
            while (bytesToCopy > 0) {
                input.get(this.mCopyBuf, 0, bytesToCopy);
                this.mGzipOut.write(this.mCopyBuf, 0, bytesToCopy);
                if (this.mBufOut.size() >= output.remaining()) break;
                bytesToCopy = Math.min(this.mCopyBuf.length, input.remaining());
            }
            if (endOfInput) {
                this.mGzipOut.flush();
            }
            this.mBufOut.transferTo(output);
            if (!output.hasRemaining()) {
                return TransformingInputStream.ETransformResult.OVERFLOW;
            }
            return TransformingInputStream.ETransformResult.UNDERFLOW;
        }

        @Override
        public TransformingInputStream.ETransformResult flush(ByteBuffer output) throws IOException {
            if (!this.mFinished) {
                this.mGzipOut.finish();
                this.mGzipOut.flush();
                this.mFinished = true;
            }
            this.mBufOut.transferTo(output);
            if (!output.hasRemaining()) {
                return TransformingInputStream.ETransformResult.OVERFLOW;
            }
            return TransformingInputStream.ETransformResult.UNDERFLOW;
        }

        @Override
        public void close() throws IOException {
            this.mGzipOut.close();
        }
    }
}

