/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends InputStream {
    private final InputStream mSource;
    private long mBytesLeft;

    public LimitedInputStream(InputStream source, long limit) {
        this.mSource = source;
        this.mBytesLeft = limit;
    }

    @Override
    public int available() throws IOException {
        long available = Math.min(this.mBytesLeft, (long)this.mSource.available());
        if (available > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)available;
    }

    @Override
    public int read() throws IOException {
        if (this.mBytesLeft > 0L) {
            int b = this.mSource.read();
            this.mBytesLeft = -1 == b ? 0L : --this.mBytesLeft;
            return b;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.mBytesLeft > 0L) {
            int actualLen = this.mSource.read(b, off, (int)Math.min((long)len, this.mBytesLeft));
            this.mBytesLeft = -1 == actualLen ? 0L : (this.mBytesLeft -= (long)actualLen);
            return actualLen;
        }
        return -1;
    }
}

