/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang.NullArgumentException;

public class ObservableCountingInputStream
extends FilterInputStream {
    private final IByteCountObserver mObserver;
    private final long mMilestoneSize;
    private long mNextMilestone;
    private long mLastCount;

    public ObservableCountingInputStream(InputStream in, IByteCountObserver observer) {
        super((InputStream)new CountingInputStream(in));
        if (null == observer) {
            throw new NullArgumentException("observer");
        }
        this.mObserver = observer;
        this.mMilestoneSize = -1L;
        this.mNextMilestone = 0L;
        this.mLastCount = 0L;
    }

    public ObservableCountingInputStream(InputStream in, IByteCountObserver observer, long milestoneSize) {
        super((InputStream)new CountingInputStream(in));
        if (null == observer) {
            throw new NullArgumentException("observer");
        }
        if (milestoneSize <= 0L) {
            throw new IllegalArgumentException("milestoneByteCount <= 0");
        }
        this.mObserver = observer;
        this.mNextMilestone = this.mMilestoneSize = milestoneSize;
        this.mLastCount = 0L;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int found = super.read(b);
        this.notifyObserverIfRequired(-1 == found);
        return found;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int found = super.read(b, off, len);
        this.notifyObserverIfRequired(-1 == found);
        return found;
    }

    @Override
    public int read() throws IOException {
        int found = super.read();
        this.notifyObserverIfRequired(-1 == found);
        return found;
    }

    @Override
    public long skip(long length) throws IOException {
        long skip = super.skip(length);
        this.notifyObserverIfRequired(false);
        return skip;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.notifyObserverIfRequired(true);
    }

    public long getByteCount() {
        return ((CountingInputStream)this.in).getByteCount();
    }

    public long resetByteCount() {
        long count = ((CountingInputStream)this.in).resetByteCount();
        this.mLastCount = 0L;
        this.notifyObserverIfRequired(true);
        return count;
    }

    private void notifyObserverIfRequired(boolean force) {
        long count = this.getByteCount();
        if (this.mMilestoneSize < 1L || force) {
            this.mObserver.onByteCountChanged(count - this.mLastCount, count);
            this.mLastCount = count;
        } else if (count >= this.mNextMilestone) {
            this.mNextMilestone = count + this.mMilestoneSize;
            this.mObserver.onByteCountChanged(count - this.mLastCount, count);
            this.mLastCount = count;
        }
    }

    public static interface IByteCountObserver {
        public void onByteCountChanged(long var1, long var3);
    }
}

