/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class StringDecoder {
    private final CharsetDecoder mDecoder;
    private CharBuffer mOutputBuf = CharBuffer.allocate(256);

    public StringDecoder(Charset charset) {
        this.mDecoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public String decode(ByteBuffer buf) {
        this.ensureOutputCapacity(buf.remaining());
        this.mOutputBuf.clear();
        this.mDecoder.reset();
        try {
            CoderResult cr = this.mDecoder.decode(buf, this.mOutputBuf, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = this.mDecoder.flush(this.mOutputBuf)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
        this.mOutputBuf.flip();
        return new String(this.mOutputBuf.array(), 0, this.mOutputBuf.remaining());
    }

    private void ensureOutputCapacity(int capacity) {
        if (this.mOutputBuf.capacity() < capacity) {
            this.mOutputBuf = CharBuffer.allocate(capacity);
        }
    }
}

