/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class StringEncoder {
    private final CharsetEncoder mEncoder;
    private CharBuffer mInputBuf = CharBuffer.allocate(256);
    private ByteBuffer mOutputBuf = ByteBuffer.allocate(512);

    public StringEncoder(Charset charset) {
        this.mEncoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public ByteBuffer encode(CharSequence str) {
        this.ensureInputCapacity(str.length());
        this.mInputBuf.clear();
        this.mInputBuf.append(str);
        this.mInputBuf.flip();
        int outputLen = (int)Math.ceil((double)this.mEncoder.averageBytesPerChar() * (double)str.length());
        this.ensureOutputCapacity(outputLen);
        if (this.doEncode()) {
            return this.mOutputBuf;
        }
        outputLen = (int)Math.ceil((double)this.mEncoder.maxBytesPerChar() * (double)str.length());
        this.ensureOutputCapacity(outputLen);
        if (this.doEncode()) {
            return this.mOutputBuf;
        }
        throw new RuntimeException("Encoding failed");
    }

    private boolean doEncode() {
        this.mInputBuf.rewind();
        this.mOutputBuf.clear();
        this.mEncoder.reset();
        try {
            CoderResult cr = this.mEncoder.encode(this.mInputBuf, this.mOutputBuf, true);
            if (cr.isOverflow()) {
                return false;
            }
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if ((cr = this.mEncoder.flush(this.mOutputBuf)).isOverflow()) {
                return false;
            }
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
        this.mOutputBuf.flip();
        return true;
    }

    private void ensureInputCapacity(int capacity) {
        if (this.mInputBuf.capacity() < capacity) {
            this.mInputBuf = CharBuffer.allocate(capacity);
        }
    }

    private void ensureOutputCapacity(int capacity) {
        if (this.mOutputBuf.capacity() < capacity) {
            this.mOutputBuf = ByteBuffer.allocate(capacity);
        }
    }
}

