/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class TransformingInputStream
extends InputStream {
    private static final int MAX_CYCLE_COUNT = 1000;
    private static final int BYTE_MASK32 = 255;
    private final InputStream mInput;
    private final ITransformer mTransformer;
    private final ByteBuffer mInputBuf;
    private final ByteBuffer mOutputBuf;
    private boolean mEndOfInput = false;
    private boolean mEndOfTransform = false;
    private boolean mEndOfOutput = false;
    private volatile boolean mClosed = false;

    public TransformingInputStream(InputStream in, ITransformer transformer) {
        this(in, transformer, 8192, 8192);
    }

    public TransformingInputStream(InputStream in, ITransformer transformer, int inBufferSize, int outBufferSize) {
        this.mInput = in;
        this.mTransformer = transformer;
        this.mInputBuf = ByteBuffer.allocate(inBufferSize);
        this.mOutputBuf = ByteBuffer.allocate(outBufferSize);
        this.mInputBuf.position(this.mInputBuf.capacity());
        this.mOutputBuf.position(this.mOutputBuf.capacity());
    }

    @Override
    public int available() throws IOException {
        this.checkIfClosed();
        return this.mOutputBuf.remaining();
    }

    @Override
    public int read() throws IOException {
        this.checkIfClosed();
        int cycleCount = 0;
        while (!this.mOutputBuf.hasRemaining()) {
            if (++cycleCount > 1000) {
                throw new IOException("Detected a possible infinite loop");
            }
            if (this.fillOutput()) continue;
        }
        if (this.mOutputBuf.hasRemaining()) {
            return this.mOutputBuf.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        this.checkIfClosed();
        int cycleCount = 0;
        while (!this.mOutputBuf.hasRemaining()) {
            if (++cycleCount > 1000) {
                throw new IOException("Detected a possible infinite loop");
            }
            if (this.fillOutput()) continue;
        }
        if (this.mOutputBuf.hasRemaining()) {
            len = Math.min(len, this.mOutputBuf.remaining());
            this.mOutputBuf.get(buf, off, len);
            return len;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            this.mClosed = true;
            try {
                this.mInput.close();
            }
            finally {
                this.mTransformer.close();
            }
        }
    }

    private boolean fillOutput() throws IOException {
        ETransformResult result;
        block6: {
            if (this.mEndOfOutput) {
                return false;
            }
            this.mOutputBuf.compact();
            int cycleCount = 0;
            do {
                result = null;
                if (++cycleCount > 1000) {
                    throw new IOException("Detected a possible infinite loop");
                }
                if (!this.fillInput()) break block6;
            } while (ETransformResult.UNDERFLOW == (result = this.mTransformer.transform(this.mInputBuf, this.mOutputBuf, false)) && !this.mOutputBuf.hasRemaining());
            this.mOutputBuf.flip();
            return true;
        }
        if (!this.mEndOfTransform) {
            result = this.mTransformer.transform(this.mInputBuf, this.mOutputBuf, true);
            if (ETransformResult.UNDERFLOW == result && !this.mInputBuf.hasRemaining()) {
                this.mEndOfTransform = true;
            }
            this.mOutputBuf.flip();
            return true;
        }
        result = this.mTransformer.flush(this.mOutputBuf);
        if (ETransformResult.OVERFLOW == result) {
            this.mOutputBuf.flip();
            return true;
        }
        this.mOutputBuf.flip();
        this.mEndOfOutput = true;
        return false;
    }

    private boolean fillInput() throws IOException {
        if (this.mEndOfInput) {
            return false;
        }
        this.mInputBuf.compact();
        int numRead = this.mInput.read(this.mInputBuf.array(), this.mInputBuf.position(), this.mInputBuf.remaining());
        if (-1 == numRead) {
            this.mInputBuf.limit(this.mInputBuf.position());
            this.mInputBuf.position(0);
            this.mEndOfInput = true;
            return false;
        }
        this.mInputBuf.limit(this.mInputBuf.position() + numRead);
        this.mInputBuf.position(0);
        return true;
    }

    private void checkIfClosed() throws IOException {
        if (this.mClosed) {
            throw new IOException("Stream was closed");
        }
    }

    public static interface ITransformer {
        public ETransformResult transform(ByteBuffer var1, ByteBuffer var2, boolean var3) throws IOException;

        public ETransformResult flush(ByteBuffer var1) throws IOException;

        public void close() throws IOException;
    }

    public static enum ETransformResult {
        UNDERFLOW,
        OVERFLOW;

    }
}

