/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import com.ibm.neo.io.IRecordTransformer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TransformingRecordIterator
implements Iterator<String[]> {
    private final Iterator<String[]> mSourceIterator;
    private final IRecordTransformer mTranformer;
    private String[][] mBuffer;
    private int mBufferInx = 0;

    public TransformingRecordIterator(Iterator<String[]> sourceIterator, IRecordTransformer transformer) {
        this.mSourceIterator = sourceIterator;
        this.mTranformer = transformer;
    }

    @Override
    public boolean hasNext() {
        return this.mBuffer != null && this.mBufferInx < this.mBuffer.length || this.mSourceIterator.hasNext();
    }

    @Override
    public String[] next() {
        if (this.mBuffer == null || this.mBufferInx >= this.mBuffer.length) {
            this.mBuffer = this.mTranformer.transform(this.mSourceIterator.next());
            if (this.mBuffer == null || this.mBuffer.length == 0) {
                throw new NoSuchElementException();
            }
            this.mBufferInx = 0;
        }
        return this.mBuffer[this.mBufferInx++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

