/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class VarIntCoder {
    private static final ThreadLocal<byte[]> SCRATCH = new ThreadLocal<byte[]>(){

        @Override
        public final byte[] initialValue() {
            return new byte[16];
        }
    };

    private VarIntCoder() {
    }

    private static long zigzagLong(long value) {
        return value << 1 ^ value >> 63;
    }

    private static int zigzagInt(int value) {
        return value << 1 ^ value >> 31;
    }

    public static int sizeofSignedVarLong(long value) {
        return VarIntCoder.sizeofUnsignedVarLong(VarIntCoder.zigzagLong(value));
    }

    public static int sizeofUnsignedVarLong(long value) {
        int bytesWritten = 1;
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            ++bytesWritten;
            value >>>= 7;
        }
        return bytesWritten;
    }

    public static int sizeofSignedVarInt(int value) {
        return VarIntCoder.sizeofUnsignedVarInt(VarIntCoder.zigzagInt(value));
    }

    public static int sizeofUnsignedVarInt(int value) {
        int bytesWritten = 1;
        while ((long)(value & 0xFFFFFF80) != 0L) {
            ++bytesWritten;
            value >>>= 7;
        }
        return bytesWritten;
    }

    public static void putSignedVarLong(long value, ByteBuffer buf) {
        VarIntCoder.putUnsignedVarLong(VarIntCoder.zigzagLong(value), buf);
    }

    public static void putUnsignedVarLong(long value, ByteBuffer buf) {
        byte[] tmp = SCRATCH.get();
        int i = 0;
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            tmp[i++] = (byte)((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
        tmp[i++] = (byte)((int)value & 0x7F);
        buf.put(tmp, 0, i);
    }

    public static void putSignedVarInt(int value, ByteBuffer buf) {
        VarIntCoder.putUnsignedVarInt(VarIntCoder.zigzagInt(value), buf);
    }

    public static void putUnsignedVarInt(int value, ByteBuffer buf) {
        byte[] tmp = SCRATCH.get();
        int i = 0;
        while ((long)(value & 0xFFFFFF80) != 0L) {
            tmp[i++] = (byte)(value & 0x7F | 0x80);
            value >>>= 7;
        }
        tmp[i++] = (byte)(value & 0x7F);
        buf.put(tmp, 0, i);
    }

    public static void writeSignedVarLong(long value, OutputStream out) throws IOException {
        VarIntCoder.writeUnsignedVarLong(VarIntCoder.zigzagLong(value), out);
    }

    public static void writeSignedVarLong2(long value, DataOutput out) throws IOException {
        VarIntCoder.writeUnsignedVarLong2(VarIntCoder.zigzagLong(value), out);
    }

    public static void writeUnsignedVarLong(long value, OutputStream out) throws IOException {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.write((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.write((int)value & 0x7F);
    }

    public static void writeUnsignedVarLong2(long value, DataOutput out) throws IOException {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.write((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.write((int)value & 0x7F);
    }

    public static void writeSignedVarInt(int value, OutputStream out) throws IOException {
        VarIntCoder.writeUnsignedVarInt(VarIntCoder.zigzagInt(value), out);
    }

    public static void writeSignedVarInt2(int value, DataOutput out) throws IOException {
        VarIntCoder.writeUnsignedVarInt2(VarIntCoder.zigzagInt(value), out);
    }

    public static void writeUnsignedVarInt(int value, OutputStream out) throws IOException {
        while ((long)(value & 0xFFFFFF80) != 0L) {
            out.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.write(value & 0x7F);
    }

    public static void writeUnsignedVarInt2(int value, DataOutput out) throws IOException {
        while ((long)(value & 0xFFFFFF80) != 0L) {
            out.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.write(value & 0x7F);
    }

    public static long getSignedVarLong(ByteBuffer buf) {
        long raw = VarIntCoder.getUnsignedVarLong(buf);
        long temp = (raw << 63 >> 63 ^ raw) >> 1;
        return temp ^ raw & Long.MIN_VALUE;
    }

    public static long getUnsignedVarLong(ByteBuffer buf) {
        long b;
        long value = 0L;
        int i = 0;
        while (((b = (long)buf.get()) & 0x80L) != 0L) {
            value |= (b & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw new IllegalArgumentException("varint exceeds 63 bits");
        }
        return value | b << i;
    }

    public static int getSignedVarInt(ByteBuffer buf) {
        int raw = VarIntCoder.getUnsignedVarInt(buf);
        int temp = (raw << 31 >> 31 ^ raw) >> 1;
        return temp ^ raw & Integer.MIN_VALUE;
    }

    public static int getUnsignedVarInt(ByteBuffer buf) {
        byte b;
        int value = 0;
        int i = 0;
        while (((b = buf.get()) & 0x80) != 0) {
            value |= (b & 0x7F) << i;
            if ((i += 7) <= 35) continue;
            throw new IllegalArgumentException("varint exceeds 35 bits");
        }
        return value | b << i;
    }

    public static long readSignedVarLong(InputStream in) throws IOException {
        long raw = VarIntCoder.readUnsignedVarLong(in);
        long temp = (raw << 63 >> 63 ^ raw) >> 1;
        return temp ^ raw & Long.MIN_VALUE;
    }

    public static long readSignedVarLong2(DataInput in) throws IOException {
        long raw = VarIntCoder.readUnsignedVarLong2(in);
        long temp = (raw << 63 >> 63 ^ raw) >> 1;
        return temp ^ raw & Long.MIN_VALUE;
    }

    public static long readUnsignedVarLong(InputStream in) throws IOException {
        long b;
        int i;
        long value;
        block2: {
            value = 0L;
            i = 0;
            do {
                if (-1L == (b = (long)in.read())) {
                    throw new EOFException("unexpected end-of-stream");
                }
                if ((b & 0x80L) == 0L) break block2;
                value |= (b & 0x7FL) << i;
            } while ((i += 7) <= 63);
            throw new IOException("varint exceeds 63 bits");
        }
        return value | b << i;
    }

    public static long readUnsignedVarLong2(DataInput in) throws IOException {
        long b;
        long value = 0L;
        int i = 0;
        while (((b = (long)in.readByte()) & 0x80L) != 0L) {
            value |= (b & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw new IOException("varint exceeds 63 bits");
        }
        return value | b << i;
    }

    public static int readSignedVarInt(InputStream in) throws IOException {
        int raw = VarIntCoder.readUnsignedVarInt(in);
        int temp = (raw << 31 >> 31 ^ raw) >> 1;
        return temp ^ raw & Integer.MIN_VALUE;
    }

    public static int readSignedVarInt2(DataInput in) throws IOException {
        int raw = VarIntCoder.readUnsignedVarInt2(in);
        int temp = (raw << 31 >> 31 ^ raw) >> 1;
        return temp ^ raw & Integer.MIN_VALUE;
    }

    public static int readUnsignedVarInt(InputStream in) throws IOException {
        int b;
        int value = 0;
        int i = 0;
        while (((long)(b = in.read()) & 0x80L) != 0L) {
            value |= (b & 0x7F) << i;
            if ((i += 7) <= 35) continue;
            throw new IOException("varint exceeds 35 bits");
        }
        return value | b << i;
    }

    public static int readUnsignedVarInt2(DataInput in) throws IOException {
        byte b;
        int value = 0;
        int i = 0;
        while (((b = in.readByte()) & 0x80) != 0) {
            value |= (b & 0x7F) << i;
            if ((i += 7) <= 35) continue;
            throw new IOException("varint exceeds 35 bits");
        }
        return value | b << i;
    }
}

