/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import java.util.Arrays;

public class WindowedCharacterBuffer {
    private char[] mWindow;
    private long mWindowPos;
    private int mUsableWindow;
    private long mMarkPos;

    public WindowedCharacterBuffer(int windowSize) {
        if (windowSize < 1) {
            throw new IllegalArgumentException("windowSize < 1");
        }
        this.mWindow = new char[windowSize];
        this.mMarkPos = -1L;
    }

    public char[] window() {
        if (this.mUsableWindow == 0) {
            return new char[0];
        }
        int adjustedWindowPos = (int)(this.mWindowPos % (long)this.mWindow.length);
        if (adjustedWindowPos - this.mUsableWindow >= 0) {
            return Arrays.copyOfRange(this.mWindow, adjustedWindowPos - this.mUsableWindow, adjustedWindowPos);
        }
        char[] result = new char[this.mUsableWindow];
        int firstChunkSize = adjustedWindowPos;
        int secondChunkSize = this.mUsableWindow - firstChunkSize;
        System.arraycopy(this.mWindow, 0, result, this.mUsableWindow - firstChunkSize, firstChunkSize);
        System.arraycopy(this.mWindow, this.mWindow.length - secondChunkSize, result, 0, secondChunkSize);
        return result;
    }

    public void mark() {
        this.mMarkPos = this.mWindowPos;
    }

    public void reset() {
        if (this.mMarkPos > -1L) {
            long charsReadSinceMark = this.mWindowPos - this.mMarkPos;
            this.mUsableWindow = (int)Math.max(0L, (long)this.mUsableWindow - charsReadSinceMark);
            this.mWindowPos = this.mMarkPos;
            this.mMarkPos = -1L;
        }
    }

    public void updateWindow(char character) {
        this.mWindow[(int)(this.mWindowPos % (long)this.mWindow.length)] = character;
        ++this.mWindowPos;
        if (this.mUsableWindow < this.mWindow.length) {
            ++this.mUsableWindow;
        }
    }

    public void updateWindow(String string) {
        this.updateWindow(string.toCharArray());
    }

    public void updateWindow(char[] cbuf) {
        this.updateWindow(cbuf, 0, cbuf.length);
    }

    public void updateWindow(char[] cbuf, int off, int len) {
        int charsToSkip = this.mWindow.length < len ? len - this.mWindow.length : 0;
        int newOff = off + charsToSkip;
        int charsToKeep = len - charsToSkip;
        if (charsToKeep > 0) {
            int adjustedWindowPos = (int)(this.mWindowPos % (long)this.mWindow.length);
            if (adjustedWindowPos + charsToKeep <= this.mWindow.length) {
                System.arraycopy(cbuf, newOff, this.mWindow, adjustedWindowPos, charsToKeep);
            } else {
                int firstChunkSize = this.mWindow.length - adjustedWindowPos;
                System.arraycopy(cbuf, newOff, this.mWindow, adjustedWindowPos, firstChunkSize);
                int secondChunkSize = charsToKeep - firstChunkSize;
                System.arraycopy(cbuf, newOff + firstChunkSize, this.mWindow, 0, secondChunkSize);
            }
            this.mWindowPos += (long)charsToKeep;
            this.mUsableWindow = Math.min(this.mUsableWindow + charsToKeep, this.mWindow.length);
        }
    }
}

