/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.io;

import com.ibm.neo.io.WindowedCharacterBuffer;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public class WindowedReader
extends Reader {
    private Reader mSource;
    private WindowedCharacterBuffer mBuffer;

    public WindowedReader(Reader reader, int windowSize) {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        this.mSource = reader;
        this.mBuffer = new WindowedCharacterBuffer(windowSize);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        int charsRead = this.mSource.read(target);
        if (charsRead > 0) {
            this.mBuffer.updateWindow(target.array(), 0, charsRead);
        }
        return charsRead;
    }

    @Override
    public int read() throws IOException {
        int charRead = this.mSource.read();
        if (charRead > -1) {
            this.mBuffer.updateWindow((char)charRead);
        }
        return charRead;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        int charsRead = this.mSource.read(cbuf);
        if (charsRead > 0) {
            this.mBuffer.updateWindow(cbuf, 0, charsRead);
        }
        return charsRead;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int charsRead = this.mSource.read(cbuf, off, len);
        if (charsRead > 0) {
            this.mBuffer.updateWindow(cbuf, off, charsRead);
        }
        return charsRead;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.mSource.skip(n);
    }

    @Override
    public boolean ready() throws IOException {
        return this.mSource.ready();
    }

    @Override
    public boolean markSupported() {
        return this.mSource.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.mSource.mark(readAheadLimit);
        this.mBuffer.mark();
    }

    @Override
    public void reset() throws IOException {
        this.mSource.reset();
        this.mBuffer.reset();
    }

    @Override
    public void close() throws IOException {
        this.mSource.close();
    }

    public char[] window() {
        return this.mBuffer.window();
    }
}

