/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.quickjson;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.neo.quickjson.resources.QuickJsonMessages;

public class QuickJson {
    private static QJValue object2Any(Object _value) throws QuickJsonUnknownTypeException {
        if (_value instanceof String) {
            return new QJSimpleValue<String>((String)_value);
        }
        if (_value instanceof Integer) {
            return new QJSimpleValue<Long>(new Long(((Integer)_value).intValue()));
        }
        if (_value instanceof Long) {
            return new QJSimpleValue<Long>((Long)_value);
        }
        if (_value instanceof Double) {
            return new QJSimpleValue<Double>((Double)_value);
        }
        if (_value instanceof Boolean) {
            return new QJSimpleValue<Boolean>((Boolean)_value);
        }
        if (_value == null) {
            return new QJSimpleValue<Object>(null);
        }
        if (_value instanceof QJValue) {
            return (QJValue)_value;
        }
        if (_value instanceof JSONArtifact) {
            return new QJSimpleValue<JSONArtifact>((JSONArtifact)_value);
        }
        if (_value instanceof QJObjectValue.Property) {
            throw new QuickJsonUnknownTypeException(QuickJsonMessages.USAGE_PR_INSIDE_OB, new Object[0]);
        }
        throw new QuickJsonUnknownTypeException(QuickJsonMessages.UNKNOW_TYPE, _value.toString(), _value.getClass().getName());
    }

    private static <T> QJValue[] simpleArray2AnyArray(T[] _values) {
        QJValue[] ret = new QJValue[_values.length];
        for (int i = 0; i < _values.length; ++i) {
            ret[i] = new QJSimpleValue<T>(_values[i]);
        }
        return ret;
    }

    private static QJValue[] objectArray2AnyArray(Object[] _values) throws QuickJsonUnknownTypeException {
        QJValue[] ret = new QJValue[_values.length];
        for (int i = 0; i < _values.length; ++i) {
            ret[i] = QuickJson.object2Any(_values[i]);
        }
        return ret;
    }

    public static QJValue qj(String _value) {
        return new QJSimpleValue<String>(_value);
    }

    public static QJValue qj(long _value) {
        return new QJSimpleValue<Long>(_value);
    }

    public static QJValue qj(double _value) {
        return new QJSimpleValue<Double>(_value);
    }

    public static QJValue qj(boolean _value) {
        return new QJSimpleValue<Boolean>(_value);
    }

    public static QJValue qj(JSONArtifact _value) {
        return new QJSimpleValue<JSONArtifact>(_value);
    }

    public static QJValue qj(QJValue _value) {
        return _value;
    }

    public static QJObjectValue ob(QJObjectValue.Property ... _properties) {
        return new QJObjectValue(_properties);
    }

    public static QJArrayValue ar() {
        return new QJArrayValue(new QJValue[0]);
    }

    public static QJArrayValue ar(String ... _values) {
        return new QJArrayValue(QuickJson.simpleArray2AnyArray(_values));
    }

    public static QJArrayValue ar(long ... _values) {
        Long[] longArr = new Long[_values.length];
        for (int i = 0; i < longArr.length; ++i) {
            longArr[i] = _values[i];
        }
        return new QJArrayValue(QuickJson.simpleArray2AnyArray(longArr));
    }

    public static QJArrayValue ar(Double ... _values) {
        return new QJArrayValue(QuickJson.simpleArray2AnyArray(_values));
    }

    public static QJArrayValue ar(Boolean ... _values) {
        return new QJArrayValue(QuickJson.simpleArray2AnyArray(_values));
    }

    public static QJArrayValue ar(QJValue ... _values) {
        return new QJArrayValue(_values);
    }

    public static QJArrayValue arM(Object ... _values) throws QuickJsonUnknownTypeException {
        return new QJArrayValue(QuickJson.objectArray2AnyArray(_values));
    }

    public static QJObjectValue.Property pr(String _key, Object _value) {
        return new QJObjectValue.Property(_key, new QJSimpleValue<Object>(_value));
    }

    public static QJObjectValue.Property pr(String _key, String _value) {
        return new QJObjectValue.Property(_key, new QJSimpleValue<String>(_value));
    }

    public static QJObjectValue.Property pr(String _key, long _value) {
        return new QJObjectValue.Property(_key, new QJSimpleValue<Long>(_value));
    }

    public static QJObjectValue.Property pr(String _key, double _value) {
        return new QJObjectValue.Property(_key, new QJSimpleValue<Double>(_value));
    }

    public static QJObjectValue.Property pr(String _key, boolean _value) {
        return new QJObjectValue.Property(_key, new QJSimpleValue<Boolean>(_value));
    }

    public static QJObjectValue.Property pr() {
        return new QJObjectValue.NoProperty();
    }

    public static QJObjectValue.Property pr(String _key, JSONArtifact _value) {
        return new QJObjectValue.Property(_key, new QJSimpleValue<JSONArtifact>(_value));
    }

    public static QJObjectValue.Property pr(String _key, QJValue _value) {
        return new QJObjectValue.Property(_key, _value);
    }

    public static QJObjectValue.Property po(String _key, Object _value) throws QuickJsonUnknownTypeException {
        return new QJObjectValue.Property(_key, QuickJson.object2Any(_value));
    }

    public static class QJArrayValue
    implements QJValue {
        public final QJValue[] m_values;

        public QJArrayValue(QJValue ... _values) {
            this.m_values = _values;
        }

        public JSONArtifact asJson4J() {
            return this.asJson4JArray();
        }

        public JSONArray asJson4JArray() {
            JSONArray ret = new JSONArray();
            for (QJValue value : this.m_values) {
                ret.add(value.asJson4J());
            }
            return ret;
        }
    }

    public static class QJObjectValue
    implements QJValue {
        public final Property[] m_pairs;

        public QJObjectValue(Property ... _pairs) {
            this.m_pairs = _pairs;
        }

        public JSONArtifact asJson4J() {
            return this.asJson4JObject();
        }

        public JSONObject asJson4JObject() {
            JSONObject ret = new JSONObject();
            for (Property pair : this.m_pairs) {
                if (pair.m_isBlank) continue;
                ret.put((Object)pair.m_key, pair.m_value == null ? null : pair.m_value.asJson4J());
            }
            return ret;
        }

        public static class NoProperty
        extends Property {
            public NoProperty() {
                super(null, null, true);
            }
        }

        public static class Property {
            public final String m_key;
            public final QJValue m_value;
            final boolean m_isBlank;

            public Property(String _key, QJValue _value) {
                this.m_key = _key;
                this.m_value = _value;
                this.m_isBlank = false;
            }

            Property(String _key, QJValue _value, boolean _isBlank) {
                this.m_key = _key;
                this.m_value = _value;
                this.m_isBlank = _isBlank;
            }
        }
    }

    public static class QJSimpleValue<T>
    implements QJValue {
        private final T m_value;

        public QJSimpleValue(T _value) {
            this.m_value = _value;
        }

        public T asJson4J() {
            return this.m_value;
        }
    }

    public static interface QJValue {
        public Object asJson4J();
    }

    public static class QuickJsonUnknownTypeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        QuickJsonUnknownTypeException(QuickJsonMessages _message, Object ... _args) {
            super(_message.format(_args));
        }
    }
}

