/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util;

import com.ibm.neo.util.ArgumentParserException;
import java.util.HashMap;
import java.util.Map;

public class ArgumentParser {
    private final String m_OptionPrefixSymbol;
    private final boolean m_KeepPrefixSymbolInKey;
    private Map<String, String> m_argsMap = new HashMap<String, String>();

    public ArgumentParser(String optionPrefixSymbol, boolean keepPrefixSymbolInKey) {
        this.m_OptionPrefixSymbol = optionPrefixSymbol;
        this.m_KeepPrefixSymbolInKey = keepPrefixSymbolInKey;
    }

    public Map<String, String> getArguments() {
        return this.m_argsMap;
    }

    public Map<String, String> parseArguments(String[] args) throws ArgumentParserException {
        HashMap<String, String> map = new HashMap<String, String>();
        String currentOption = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith(this.m_OptionPrefixSymbol)) {
                currentOption = this.m_KeepPrefixSymbolInKey ? arg : arg.substring(this.m_OptionPrefixSymbol.length());
                map.put(currentOption, null);
            } else if (currentOption != null && currentOption.length() > 0) {
                String newValue = (String)map.get(currentOption);
                newValue = newValue == null ? arg : newValue + " " + arg;
                map.put(currentOption, newValue);
            } else {
                throw new ArgumentParserException("Argument '" + arg + "' at position " + i + " is not preceeded by a well" + "-formed option argument (an argument starting with the symbol '" + this.m_OptionPrefixSymbol + "').");
            }
            this.m_argsMap = map;
        }
        return map;
    }

    public boolean isEmpty() {
        return this.m_argsMap.isEmpty();
    }

    public boolean containsKey(String _argName) {
        return this.m_argsMap.containsKey(_argName);
    }

    public String getOptionalArg(String _argName) {
        return this.m_argsMap.get(_argName);
    }

    public String getMandatoryArg(String _argName) {
        if (this.m_argsMap.containsKey(_argName)) {
            return this.m_argsMap.get(_argName);
        }
        throw new RuntimeException("You need to provide a " + this.m_OptionPrefixSymbol + _argName + " argument.");
    }
}

