/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util;

import com.ibm.neo.exception.AssertionFailedException;

public class Assertions {
    private Assertions() {
    }

    public static void assertTrue(boolean condition) throws AssertionFailedException {
        Assertions.assertTrue(condition, null);
    }

    public static void assertTrue(boolean condition, String details) throws AssertionFailedException {
        if (!condition) {
            Assertions.throwAssertionFailed("assertTrue", details);
        }
    }

    public static void assertFalse(boolean condition) throws AssertionFailedException {
        Assertions.assertFalse(condition, null);
    }

    public static void assertFalse(boolean condition, String details) throws AssertionFailedException {
        if (condition) {
            Assertions.throwAssertionFailed("assertFalse", details);
        }
    }

    public static void assertNull(Object value) throws AssertionFailedException {
        Assertions.assertNull(value, null);
    }

    public static void assertNull(Object value, String details) throws AssertionFailedException {
        if (null != value) {
            Assertions.throwAssertionFailed("assertNull", details);
        }
    }

    public static void assertNotNull(Object value) throws AssertionFailedException {
        Assertions.assertNotNull(value, null);
    }

    public static void assertNotNull(Object value, String details) throws AssertionFailedException {
        if (null == value) {
            Assertions.throwAssertionFailed("assertNotNull", details);
        }
    }

    public static void assertSame(Object expected, Object actual) throws AssertionFailedException {
        Assertions.assertSame(expected, actual, null);
    }

    public static void assertSame(Object expected, Object actual, String details) throws AssertionFailedException {
        if (expected != actual) {
            Assertions.throwAssertionFailed("assertSame", details);
        }
    }

    public static void assertNotSame(Object expected, Object actual) throws AssertionFailedException {
        Assertions.assertNotSame(expected, actual, null);
    }

    public static void assertNotSame(Object expected, Object actual, String details) throws AssertionFailedException {
        if (expected == actual) {
            Assertions.throwAssertionFailed("assertNotSame", details);
        }
    }

    public static void assertEqual(Object expected, Object actual) throws AssertionFailedException {
        Assertions.assertEqual(expected, actual, null);
    }

    public static void assertEqual(Object expected, Object actual, String details) throws AssertionFailedException {
        if (null == expected) {
            if (null != actual) {
                Assertions.throwAssertionFailed("assertEqual", details);
            }
        } else if (null == actual) {
            Assertions.throwAssertionFailed("assertEqual", details);
        } else if (!expected.equals(actual)) {
            Assertions.throwAssertionFailed("assertEqual", details);
        }
    }

    public static void assertNotEqual(Object expected, Object actual) throws AssertionFailedException {
        Assertions.assertNotEqual(expected, actual, null);
    }

    public static void assertNotEqual(Object expected, Object actual, String details) throws AssertionFailedException {
        if (null == expected) {
            if (null == actual) {
                Assertions.throwAssertionFailed("assertNotEqual", details);
            }
        } else if (null != actual && expected.equals(actual)) {
            Assertions.throwAssertionFailed("assertNotEqual", details);
        }
    }

    public static void assertPositive(long n) throws AssertionFailedException {
        Assertions.assertPositive(n, null);
    }

    public static void assertPositive(long n, String details) throws AssertionFailedException {
        if (n < 0L) {
            Assertions.throwAssertionFailed("assertPositive", details);
        }
    }

    public static void assertPositive(double n) throws AssertionFailedException {
        Assertions.assertPositive(n, null);
    }

    public static void assertPositive(double n, String details) throws AssertionFailedException {
        if (n < 0.0) {
            Assertions.throwAssertionFailed("assertPositive", details);
        }
    }

    public static void assertNegative(long n) throws AssertionFailedException {
        Assertions.assertNegative(n, null);
    }

    public static void assertNegative(long n, String details) throws AssertionFailedException {
        if (n > 0L) {
            Assertions.throwAssertionFailed("assertNegative", details);
        }
    }

    public static void assertNegative(double n) throws AssertionFailedException {
        Assertions.assertNegative(n, null);
    }

    public static void assertNegative(double n, String details) throws AssertionFailedException {
        if (n > 0.0) {
            Assertions.throwAssertionFailed("assertNegative", details);
        }
    }

    public static void assertInRange(long n, long start, long end) throws AssertionFailedException {
        Assertions.assertInRange(n, start, end, null);
    }

    public static void assertInRange(long n, long start, long end, String details) throws AssertionFailedException {
        if (n < start || n >= end) {
            Assertions.throwAssertionFailed("assertInRange", details);
        }
    }

    public static void assertGreaterThanZero(long n) throws AssertionFailedException {
        if (n <= 0L) {
            Assertions.throwAssertionFailed("assertGreaterThanZero", null);
        }
    }

    public static void assertGreaterThanZero(long n, String details) throws AssertionFailedException {
        if (n <= 0L) {
            Assertions.throwAssertionFailed("assertGreaterThanZero", details);
        }
    }

    public static void assertGreaterThanZero(double n) throws AssertionFailedException {
        if (n <= 0.0) {
            Assertions.throwAssertionFailed("assertGreaterThanZero", null);
        }
    }

    public static void assertGreaterThanZero(double n, String details) throws AssertionFailedException {
        if (n <= 0.0) {
            Assertions.throwAssertionFailed("assertGreaterThanZero", details);
        }
    }

    private static void throwAssertionFailed(String conditionType, String details) throws AssertionFailedException {
        StringBuilder builder = new StringBuilder();
        builder.append(conditionType).append(" condition failed");
        if (null != details) {
            builder.append(": ").append(details);
        }
        throw new AssertionFailedException(builder.toString());
    }
}

