/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util;

public class BitMask {
    private static final int[] FILLED_INT32_MASKS = new int[32];
    private static final long[] FILLED_INT64_MASKS = new long[64];

    public static int fillLow32(int numBits) {
        if (numBits < 0 || numBits > 32) {
            throw new IllegalArgumentException("Illegal number of bits");
        }
        if (numBits == 0) {
            return 0;
        }
        return FILLED_INT32_MASKS[numBits - 1];
    }

    public static long fillLow64(int numBits) {
        if (numBits < 0 || numBits > 64) {
            throw new IllegalArgumentException("Illegal number of bits");
        }
        if (numBits == 0) {
            return 0L;
        }
        return FILLED_INT64_MASKS[numBits - 1];
    }

    public static int fillHigh32(int numBits) {
        return BitMask.fillLow32(numBits) << 32 - numBits;
    }

    public static long fillHigh64(int numBits) {
        return BitMask.fillLow64(numBits) << 64 - numBits;
    }

    public static int fillRange32(int start, int end) {
        if (start < 0 || start > 31) {
            throw new IllegalArgumentException("start out of range");
        }
        if (end < 0 || end > 32) {
            throw new IllegalArgumentException("end out of range");
        }
        if (start > end) {
            throw new IllegalArgumentException("start > end");
        }
        if (start == end) {
            return 0;
        }
        int numBits = end - start;
        return BitMask.fillLow32(numBits) << start;
    }

    public static long fillRange64(int start, int end) {
        if (start < 0 || start > 63) {
            throw new IllegalArgumentException("start out of range");
        }
        if (end < 0 || end > 64) {
            throw new IllegalArgumentException("end out of range");
        }
        if (start > end) {
            throw new IllegalArgumentException("start > end");
        }
        if (start == end) {
            return 0L;
        }
        int numBits = end - start;
        return BitMask.fillLow64(numBits) << start;
    }

    static {
        int mask = 1;
        int value = 0;
        for (int i = 0; i < 32; ++i) {
            BitMask.FILLED_INT32_MASKS[i] = value |= (mask <<= 1);
        }
        long mask2 = 1L;
        long value2 = 0L;
        for (int i = 0; i < 64; ++i) {
            BitMask.FILLED_INT64_MASKS[i] = value2 |= (mask2 <<= 1);
        }
    }
}

