/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class CappedIterator<T>
implements Iterator<T> {
    private final Iterator<T> mIterator;
    private final long mLimit;
    private long mCurrentCount;

    public CappedIterator(Iterator<T> iterator, long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("limit cannot be negative.");
        }
        this.mIterator = iterator;
        this.mLimit = limit;
        this.mCurrentCount = 0L;
    }

    @Override
    public boolean hasNext() {
        if (this.mCurrentCount >= this.mLimit) {
            return false;
        }
        return this.mIterator.hasNext();
    }

    @Override
    public T next() {
        if (this.mCurrentCount >= this.mLimit) {
            throw new NoSuchElementException();
        }
        T next = this.mIterator.next();
        ++this.mCurrentCount;
        return next;
    }

    @Override
    public void remove() {
        this.mIterator.remove();
    }

    public boolean hasReachedLimit() {
        return this.mCurrentCount >= this.mLimit;
    }
}

