/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;

public class ContendedOperationManager<V> {
    private final ConcurrentHashMap<Object, OpResult<V>> mPendingResults = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public V execute(IContendedOperation<V> op) throws ExecutionException, PreConditionFailed {
        OpResult otherResult;
        OpResult result = new OpResult();
        do {
            OpResult opResult;
            if (null == (otherResult = this.mPendingResults.putIfAbsent(op.getOperationKey(), result))) {
                opResult = result;
                synchronized (opResult) {
                    if (!op.checkPreCondition()) {
                        result.mAborted = true;
                        throw new PreConditionFailed();
                    }
                    result.mValue = op.call();
                    Object object = result.mValue;
                    return (V)object;
                    {
                        catch (Throwable ex) {
                            result.mError = ex;
                            throw new ExecutionException(ex);
                        }
                    }
                    finally {
                        result.mDone = true;
                        result.notifyAll();
                        this.mPendingResults.remove(op.getOperationKey(), result);
                    }
                }
            }
            opResult = otherResult;
            synchronized (opResult) {
                while (!otherResult.mDone) {
                    try {
                        otherResult.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
        } while (otherResult.mAborted || null != otherResult.mError);
        return (V)otherResult.mValue;
    }

    private static final class OpResult<V> {
        private volatile boolean mDone = false;
        private volatile V mValue = null;
        private volatile Throwable mError = null;
        private volatile boolean mAborted = false;

        private OpResult() {
        }
    }

    public static final class PreConditionFailed
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static interface IContendedOperation<V>
    extends Callable<V> {
        public Object getOperationKey();

        public boolean checkPreCondition();
    }
}

