/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util;

public class CyclicArray<E> {
    private final E[] mElements;
    private int mInsertIndex = 0;

    public CyclicArray(int capacity) {
        this.mElements = new Object[capacity];
    }

    public int capacity() {
        return this.mElements.length;
    }

    public E get(int index) {
        return this.mElements[index % this.mElements.length];
    }

    public void set(int index, E value) {
        this.mElements[index % this.mElements.length] = value;
    }

    public void add(E value) {
        this.mElements[this.mInsertIndex] = value;
        this.mInsertIndex = (this.mInsertIndex + 1) % this.mElements.length;
    }

    public void clear() {
        for (int i = 0; i < this.mElements.length; ++i) {
            this.mElements[i] = null;
        }
        this.mInsertIndex = 0;
    }
}

