/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public final class DOM4JUtils {
    public static final DocumentFactory DOCUMENT_FACTORY = DocumentFactory.getInstance();

    public static Document createDocument() {
        return DOCUMENT_FACTORY.createDocument();
    }

    public static Document createDocument(String encoding) {
        return DOCUMENT_FACTORY.createDocument(encoding);
    }

    public static Document parseDocument(String str, boolean validating) throws DocumentException {
        SAXReader reader = new SAXReader(validating);
        return reader.read(str);
    }

    public static Document parseDocument(InputStream is, boolean validating) throws DocumentException {
        SAXReader reader = new SAXReader(validating);
        return reader.read(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseDocument(File file, boolean validating) throws IOException, DocumentException {
        try (FileInputStream is = new FileInputStream(file);){
            Document document = DOM4JUtils.parseDocument(is, validating);
            return document;
        }
    }

    public static void serializeDocument(OutputStream os, Document doc, boolean prettyPrint) throws IOException {
        OutputFormat format = prettyPrint ? OutputFormat.createPrettyPrint() : OutputFormat.createCompactFormat();
        XMLWriter writer = new XMLWriter(os, format);
        writer.write(doc);
        writer.flush();
    }

    public static void serializeDocument(Writer writer, Document doc, boolean prettyPrint) throws IOException {
        OutputFormat format = prettyPrint ? OutputFormat.createPrettyPrint() : OutputFormat.createCompactFormat();
        XMLWriter xmlWriter = new XMLWriter(writer, format);
        xmlWriter.write(doc);
        xmlWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeDocument(File file, Document doc, boolean prettyPrint) throws IOException {
        try (FileOutputStream os = new FileOutputStream(file);){
            DOM4JUtils.serializeDocument(os, doc, prettyPrint);
        }
    }

    public static String serializeDocumentAsString(File file, Document doc, boolean prettyPrint) throws IOException {
        StringWriter writer = new StringWriter();
        DOM4JUtils.serializeDocument(writer, doc, prettyPrint);
        return writer.toString();
    }

    public static void serializeNode(OutputStream os, Node node, boolean prettyPrint) throws IOException {
        OutputFormat format = prettyPrint ? OutputFormat.createPrettyPrint() : OutputFormat.createCompactFormat();
        XMLWriter writer = new XMLWriter(os, format);
        writer.write(node);
        writer.flush();
    }

    public static void serializeNode(Writer writer, Node node, boolean prettyPrint) throws IOException {
        OutputFormat format = prettyPrint ? OutputFormat.createPrettyPrint() : OutputFormat.createCompactFormat();
        XMLWriter xmlWriter = new XMLWriter(writer, format);
        xmlWriter.write(node);
        xmlWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeNode(File file, Node node, boolean prettyPrint) throws IOException {
        try (FileOutputStream os = new FileOutputStream(file);){
            DOM4JUtils.serializeNode(os, node, prettyPrint);
        }
    }

    public static String serializeNodeAsString(Node node, boolean prettyPrint) throws IOException {
        StringWriter writer = new StringWriter();
        DOM4JUtils.serializeNode(writer, node, prettyPrint);
        return writer.toString();
    }

    public static List<Element> elementsOf(Element elem) {
        return elem.elements();
    }

    public static List<Element> elementsOf(Element elem, String name) {
        return elem.elements(name);
    }

    private DOM4JUtils() {
    }
}

