/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.mutable.MutableInt;

public class FrequencyCounter<T> {
    private final Map<T, MutableInt> mCounters = new HashMap<T, MutableInt>();
    private int mTotalCount = 0;

    public void increment(T obj) {
        MutableInt counter = this.mCounters.get(obj);
        if (null == counter) {
            counter = new MutableInt(0);
            this.mCounters.put(obj, counter);
        }
        counter.increment();
        ++this.mTotalCount;
    }

    public <U extends T> int frequency(U obj) {
        MutableInt counter = this.mCounters.get(obj);
        if (null == counter) {
            return 0;
        }
        return counter.intValue();
    }

    public <U extends T> int frequency(U ... objs) {
        int count = 0;
        for (U t : objs) {
            count += this.frequency(t);
        }
        return count;
    }

    public int frequency(Collection<? extends T> col) {
        int count = 0;
        for (T t : col) {
            count += this.frequency((U)t);
        }
        return count;
    }

    public <U extends T> float relativeFrequency(U obj) {
        return (float)this.frequency(obj) / (float)this.total();
    }

    public <U extends T> float relativeFrequency(U ... objs) {
        return (float)this.frequency(objs) / (float)this.total();
    }

    public float relativeFrequency(Collection<? extends T> col) {
        return (float)this.frequency(col) / (float)this.total();
    }

    public int total() {
        return this.mTotalCount;
    }

    public Set<T> items() {
        return this.mCounters.keySet();
    }

    public List<T> itemsSorted(boolean descending) {
        ArrayList<T> items = new ArrayList<T>(this.mCounters.keySet());
        if (descending) {
            Collections.sort(items, new DescendingCountComparator());
        } else {
            Collections.sort(items, new AscendingCountComparator());
        }
        return items;
    }

    public T mostFrequentItem() {
        T item = null;
        int maxCount = Integer.MIN_VALUE;
        for (Map.Entry<T, MutableInt> e : this.mCounters.entrySet()) {
            if (e.getValue().intValue() <= maxCount) continue;
            item = e.getKey();
            maxCount = e.getValue().intValue();
        }
        return item;
    }

    public Set<T> mostFrequentItems() {
        HashSet<T> items = new HashSet<T>();
        int maxCount = Integer.MIN_VALUE;
        for (Map.Entry<T, MutableInt> e : this.mCounters.entrySet()) {
            int count = e.getValue().intValue();
            if (count > maxCount) {
                items.clear();
                items.add(e.getKey());
                maxCount = count;
                continue;
            }
            if (count != maxCount) continue;
            items.add(e.getKey());
        }
        return items;
    }

    public T leastFrequentItem() {
        T item = null;
        int minCount = Integer.MAX_VALUE;
        for (Map.Entry<T, MutableInt> e : this.mCounters.entrySet()) {
            if (e.getValue().intValue() >= minCount) continue;
            item = e.getKey();
            minCount = e.getValue().intValue();
        }
        return item;
    }

    public Set<T> leastFrequentItems() {
        HashSet<T> items = new HashSet<T>();
        int minCount = Integer.MAX_VALUE;
        for (Map.Entry<T, MutableInt> e : this.mCounters.entrySet()) {
            int count = e.getValue().intValue();
            if (count < minCount) {
                items.clear();
                items.add(e.getKey());
                minCount = count;
                continue;
            }
            if (count != minCount) continue;
            items.add(e.getKey());
        }
        return items;
    }

    public String toString() {
        return this.mCounters.toString();
    }

    private final class AscendingCountComparator
    implements Comparator<T> {
        private AscendingCountComparator() {
        }

        @Override
        public int compare(T t1, T t2) {
            int c2;
            int c1 = FrequencyCounter.this.frequency(t1);
            if (c1 < (c2 = FrequencyCounter.this.frequency(t2))) {
                return -1;
            }
            if (c1 > c2) {
                return 1;
            }
            return 0;
        }
    }

    private final class DescendingCountComparator
    implements Comparator<T> {
        private DescendingCountComparator() {
        }

        @Override
        public int compare(T t1, T t2) {
            int c2;
            int c1 = FrequencyCounter.this.frequency(t1);
            if (c1 < (c2 = FrequencyCounter.this.frequency(t2))) {
                return 1;
            }
            if (c1 > c2) {
                return -1;
            }
            return 0;
        }
    }
}

