/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HashList<K, V> {
    private final Map<K, List<V>> m_map;

    public HashList() {
        this.m_map = new HashMap<K, List<V>>();
    }

    public HashList(int _size) {
        this.m_map = new HashMap<K, List<V>>(_size);
    }

    public HashList(Map<K, List<V>> _map) {
        this.m_map = _map != null ? _map : new HashMap<K, List<V>>();
    }

    public V remove(K _key, V _object) {
        V obj = null;
        List<V> list = this.get(_key);
        if (list.remove(_object)) {
            obj = _object;
        }
        if (list.isEmpty()) {
            this.m_map.remove(_key);
        }
        return obj;
    }

    public int size() {
        return this.m_map.size();
    }

    public int totalSize() {
        Set<K> keys = this.m_map.keySet();
        int total = 0;
        for (K key : keys) {
            total += this.get(key).size();
        }
        return total;
    }

    public boolean isEmpty() {
        return this.m_map.size() == 0;
    }

    public boolean containsKey(K _key) {
        return this.m_map.containsKey(_key);
    }

    public boolean containsValue(V _val) {
        for (List<V> entryList : this.m_map.values()) {
            boolean containsVal = entryList.contains(_val);
            if (!containsVal) continue;
            return true;
        }
        return false;
    }

    public void put(K _key, V _value) {
        List<V> list = this.get(_key);
        list.add(_value);
    }

    public void clear(K _key) {
        if (this.m_map.containsKey(_key)) {
            this.m_map.get(_key).clear();
        }
    }

    public Object remove(K _key) {
        return this.m_map.remove(_key);
    }

    public void clear() {
        this.m_map.clear();
    }

    public Set<K> keySet() {
        return this.m_map.keySet();
    }

    public Collection<V> values() {
        ArrayList<V> contentsList = new ArrayList<V>();
        for (List<V> entryList : this.m_map.values()) {
            Iterator<V> hashedListIter = entryList.iterator();
            while (hashedListIter.hasNext()) {
                contentsList.add(hashedListIter.next());
            }
        }
        return contentsList;
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.m_map.entrySet();
    }

    public List<V> get(K _key) {
        List<V> list = this.m_map.get(_key);
        if (list == null) {
            list = new ArrayList<V>();
            this.m_map.put(_key, list);
        }
        return list;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<K, List<V>> item : this.m_map.entrySet()) {
            List<V> values = item.getValue();
            K key = item.getKey();
            if (buffer.length() != 0) {
                buffer.append("\n");
            }
            buffer.append(key.toString());
            buffer.append(": ");
            for (int i = 0; i < values.size(); ++i) {
                buffer.append(values.get(i).toString());
                if (i >= values.size() - 1) continue;
                buffer.append(", ");
            }
        }
        return buffer.toString();
    }
}

