/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.neo.util.IJSONCodable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.NullArgumentException;

public final class JSONUtils {
    private JSONUtils() {
    }

    public static JSONObjectBuilder<JSONBuilder<?, ?>> newJSONObjectBuilder() {
        return new JSONObjectBuilder();
    }

    public static JSONArrayBuilder<JSONBuilder<?, ?>> newJSONArrayBuilder() {
        return new JSONArrayBuilder();
    }

    public static <T> T get(JSONObject obj, Class<T> type, Object ... path) {
        if (null == type) {
            throw new NullArgumentException("type was null");
        }
        if (null == path) {
            throw new NullArgumentException("path was null");
        }
        if (path.length == 0) {
            throw new IllegalArgumentException("path.length == 0");
        }
        Object result = obj;
        for (Object e : path) {
            if (result instanceof JSONObject) {
                result = result.get((Object)String.valueOf(e));
                continue;
            }
            if (result instanceof JSONArray) {
                if (e instanceof Number) {
                    result = ((JSONArray)result).get(((Number)e).intValue());
                    continue;
                }
                try {
                    int index = Integer.parseInt(String.valueOf(e));
                    result = ((JSONArray)result).get(index);
                    continue;
                }
                catch (NumberFormatException ex) {
                    result = null;
                    break;
                }
            }
            result = null;
            break;
        }
        return type.cast(result);
    }

    public static String getString(JSONObject obj, Object ... path) {
        return JSONUtils.get(obj, String.class, path);
    }

    public static String getString(JSONArray array, int index) {
        return (String)array.get(index);
    }

    public static Number getNumber(JSONObject obj, Object ... path) {
        return JSONUtils.get(obj, Number.class, path);
    }

    public static Number getNumber(JSONArray array, int index) {
        return (Number)array.get(index);
    }

    public static int getInt(JSONObject obj, Object ... path) {
        return JSONUtils.getNumber(obj, path).intValue();
    }

    public static int getIntWithDefault(JSONObject obj, int defaultValue, Object ... path) {
        Number n = JSONUtils.getNumber(obj, path);
        if (null == n) {
            return defaultValue;
        }
        return n.intValue();
    }

    public static int getInt(JSONArray array, int index) {
        return JSONUtils.getNumber(array, index).intValue();
    }

    public static long getLong(JSONObject obj, Object ... path) {
        return JSONUtils.getNumber(obj, path).longValue();
    }

    public static long getLongWithDefault(JSONObject obj, long defaultValue, Object ... path) {
        Number n = JSONUtils.getNumber(obj, path);
        if (null == n) {
            return defaultValue;
        }
        return n.longValue();
    }

    public static long getLong(JSONArray array, int index) {
        return JSONUtils.getNumber(array, index).longValue();
    }

    public static float getFloat(JSONObject obj, Object ... path) {
        return JSONUtils.getNumber(obj, path).floatValue();
    }

    public static float getFloatWithDefault(JSONObject obj, float defaultValue, Object ... path) {
        Number n = JSONUtils.getNumber(obj, path);
        if (null == n) {
            return defaultValue;
        }
        return n.floatValue();
    }

    public static float getFloat(JSONArray array, int index) {
        return JSONUtils.getNumber(array, index).floatValue();
    }

    public static double getDouble(JSONObject obj, Object ... path) {
        return JSONUtils.getNumber(obj, path).doubleValue();
    }

    public static double getDoubleWithDefault(JSONObject obj, double defaultValue, Object ... path) {
        Number n = JSONUtils.getNumber(obj, path);
        if (null == n) {
            return defaultValue;
        }
        return n.doubleValue();
    }

    public static double getDouble(JSONArray array, int index) {
        return JSONUtils.getNumber(array, index).doubleValue();
    }

    public static boolean getBoolean(JSONObject obj, Object ... path) {
        return JSONUtils.get(obj, Boolean.class, path);
    }

    public static boolean getBooleanWithDefault(JSONObject obj, boolean defaultValue, Object ... path) {
        Boolean b = JSONUtils.get(obj, Boolean.class, path);
        if (null == b) {
            return defaultValue;
        }
        return b;
    }

    public static boolean getBoolean(JSONArray array, int index) {
        Boolean b = (Boolean)array.get(index);
        return b;
    }

    public static JSONObject getJSONObject(JSONObject obj, Object ... path) {
        return JSONUtils.get(obj, JSONObject.class, path);
    }

    public static JSONObject getJSONObject(JSONArray array, int index) {
        return (JSONObject)array.get(index);
    }

    public static JSONArray getJSONArray(JSONObject obj, Object ... path) {
        return JSONUtils.get(obj, JSONArray.class, path);
    }

    public static JSONArray getJSONArray(JSONArray array, int index) {
        return (JSONArray)array.get(index);
    }

    public static JSONObject toJSONObject(IJSONCodable codable) {
        if (null == codable) {
            return null;
        }
        JSONObject o = new JSONObject();
        codable.encodeJSON(o);
        return o;
    }

    public static <E> JSONArray toJSONArray(E[] array) {
        JSONArray result = new JSONArray(array.length);
        for (E e : array) {
            if (e instanceof IJSONCodable) {
                JSONObject o = new JSONObject();
                ((IJSONCodable)e).encodeJSON(o);
                result.add((Object)o);
                continue;
            }
            result.add(e);
        }
        return result;
    }

    public static <E> JSONArray toJSONArray(Collection<E> collection) {
        JSONArray result = new JSONArray(collection.size());
        for (E e : collection) {
            if (e instanceof IJSONCodable) {
                JSONObject o = new JSONObject();
                ((IJSONCodable)e).encodeJSON(o);
                result.add((Object)o);
                continue;
            }
            result.add(e);
        }
        return result;
    }

    public static JSONArray toJSONArray(boolean[] array) {
        JSONArray result = new JSONArray(array.length);
        for (boolean b : array) {
            result.add((Object)b);
        }
        return result;
    }

    public static JSONArray toJSONArray(int[] array) {
        JSONArray result = new JSONArray(array.length);
        for (int i : array) {
            result.add((Object)i);
        }
        return result;
    }

    public static JSONArray toJSONArray(long[] array) {
        JSONArray result = new JSONArray(array.length);
        for (long l : array) {
            result.add((Object)l);
        }
        return result;
    }

    public static JSONArray toJSONArray(float[] array) {
        JSONArray result = new JSONArray(array.length);
        for (float f : array) {
            result.add((Object)Float.valueOf(f));
        }
        return result;
    }

    public static JSONArray toJSONArray(double[] array) {
        JSONArray result = new JSONArray(array.length);
        for (double d : array) {
            result.add((Object)d);
        }
        return result;
    }

    public static JSONObject shallowClone(JSONObject obj) {
        Iterator keyIter;
        OrderedJSONObject result;
        if (obj instanceof OrderedJSONObject) {
            result = new OrderedJSONObject();
            keyIter = ((OrderedJSONObject)obj).getOrder();
        } else {
            result = new JSONObject();
            keyIter = obj.keySet().iterator();
        }
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            Object value = obj.get((Object)key);
            result.put((Object)key, value);
        }
        return result;
    }

    public static JSONArray shallowClone(JSONArray array) {
        JSONArray result = new JSONArray(array.size());
        for (Object e : array) {
            result.add(e);
        }
        return result;
    }

    public static JSONObject deepClone(JSONObject obj) {
        Iterator keyIter;
        OrderedJSONObject result;
        if (obj instanceof OrderedJSONObject) {
            result = new OrderedJSONObject();
            keyIter = ((OrderedJSONObject)obj).getOrder();
        } else {
            result = new JSONObject();
            keyIter = obj.keySet().iterator();
        }
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            Object value = obj.get((Object)key);
            if (value instanceof JSONObject) {
                result.put((Object)key, (Object)JSONUtils.deepClone((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                result.put((Object)key, (Object)JSONUtils.deepClone((JSONArray)value));
                continue;
            }
            result.put((Object)key, value);
        }
        return result;
    }

    public static JSONArray deepClone(JSONArray array) {
        JSONArray result = new JSONArray(array.size());
        for (Object e : array) {
            if (e instanceof JSONObject) {
                result.add((Object)JSONUtils.deepClone((JSONObject)e));
                continue;
            }
            if (e instanceof JSONArray) {
                result.add((Object)JSONUtils.deepClone((JSONArray)e));
                continue;
            }
            result.add(e);
        }
        return result;
    }

    public static final class JSONArrayBuilder<B extends JSONBuilder<?, ?>>
    extends JSONBuilder<JSONArray, B> {
        private final JSONArray mArray = new JSONArray();

        private JSONArrayBuilder() {
            super(null, null);
        }

        private JSONArrayBuilder(B enclosingBuilder) {
            super(enclosingBuilder, null);
        }

        private JSONArrayBuilder(B enclosingBuilder, String enclosingKey) {
            super(enclosingBuilder, enclosingKey);
        }

        @Override
        protected void onNestedBuilderPopped(JSONBuilder<?, ?> nestedBuilder) {
            this.mArray.add(nestedBuilder.build());
        }

        public JSONArrayBuilder<B> add(Object value) {
            this.mArray.add(value);
            return this;
        }

        public JSONObjectBuilder<JSONArrayBuilder<B>> addNewJSONObject() {
            return new JSONObjectBuilder<JSONArrayBuilder<B>>((JSONBuilder)this, null);
        }

        public JSONArrayBuilder<JSONArrayBuilder<B>> addNewJSONArray() {
            return new JSONArrayBuilder<JSONArrayBuilder<B>>(this);
        }

        public JSONArrayBuilder<B> clear() {
            this.mArray.clear();
            return this;
        }

        @Override
        public JSONArray build() {
            return JSONUtils.deepClone(this.mArray);
        }

        /* synthetic */ JSONArrayBuilder(JSONBuilder x0, String x1, 1 x2) {
            this(x0, x1);
        }
    }

    public static final class JSONObjectBuilder<B extends JSONBuilder<?, ?>>
    extends JSONBuilder<JSONObject, B> {
        private final JSONObject mObject = new OrderedJSONObject();

        private JSONObjectBuilder() {
            super(null, null);
        }

        private JSONObjectBuilder(B enclosingBuilder) {
            super(enclosingBuilder, null);
        }

        private JSONObjectBuilder(B enclosingBuilder, String enclosingKey) {
            super(enclosingBuilder, enclosingKey);
        }

        @Override
        protected void onNestedBuilderPopped(JSONBuilder<?, ?> nestedBuilder) {
            this.mObject.put((Object)nestedBuilder.getEnclosingKey(), nestedBuilder.build());
        }

        public JSONObjectBuilder<B> put(String key, Object value) {
            this.mObject.put((Object)key, value);
            return this;
        }

        public JSONObjectBuilder<JSONObjectBuilder<B>> putNewJSONObject(String key) {
            return new JSONObjectBuilder<JSONObjectBuilder<B>>(this, key);
        }

        public JSONArrayBuilder<JSONObjectBuilder<B>> putNewJSONArray(String key) {
            return new JSONArrayBuilder<JSONObjectBuilder<B>>(this, key, null);
        }

        public JSONObjectBuilder<B> clear() {
            this.mObject.clear();
            return this;
        }

        @Override
        public JSONObject build() {
            return JSONUtils.deepClone(this.mObject);
        }

        /* synthetic */ JSONObjectBuilder(JSONBuilder x0, 1 x1) {
            this(x0);
        }
    }

    public static abstract class JSONBuilder<T, B extends JSONBuilder<?, ?>> {
        private final B mEnclosingBuilder;
        private final String mEnclosingKey;

        protected JSONBuilder(B enclosingBuilder, String enclosingKey) {
            this.mEnclosingBuilder = enclosingBuilder;
            this.mEnclosingKey = enclosingKey;
        }

        protected String getEnclosingKey() {
            return this.mEnclosingKey;
        }

        protected abstract void onNestedBuilderPopped(JSONBuilder<?, ?> var1);

        public abstract T build();

        public final B pop() {
            if (null == this.mEnclosingBuilder) {
                throw new IllegalStateException("No enclosing builder");
            }
            ((JSONBuilder)this.mEnclosingBuilder).onNestedBuilderPopped(this);
            return this.mEnclosingBuilder;
        }
    }
}

