/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class LRUCache<K, V> {
    private final int mCapacity;
    private final ConcurrentHashMap<K, V> mKey2Value = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<K> mKeyQueue = new ConcurrentLinkedQueue();
    private final IRemovalHandler<K, V> mHandler;

    public LRUCache(int capacity) {
        this(capacity, null);
    }

    public LRUCache(int capacity, IRemovalHandler<K, V> handler) {
        this.mCapacity = capacity;
        this.mHandler = handler;
    }

    public int size() {
        return this.mKey2Value.size();
    }

    public boolean containsKey(K key) {
        return this.mKey2Value.containsKey(key);
    }

    public V get(K key) {
        return this.mKey2Value.get(key);
    }

    public V put(K key, V value) {
        V oldValue = this.mKey2Value.put(key, value);
        if (null != oldValue) {
            if (null != this.mHandler) {
                this.mHandler.onReplaced(key, oldValue);
            }
            return oldValue;
        }
        this.mKeyQueue.add(key);
        this.expireOldestIfOverCapacity();
        return null;
    }

    public V putIfAbsent(K key, V value) {
        V oldValue = this.mKey2Value.putIfAbsent(key, value);
        if (null == oldValue) {
            this.mKeyQueue.add(key);
            this.expireOldestIfOverCapacity();
        }
        return oldValue;
    }

    public void invalidate(K key) {
        V oldValue = this.mKey2Value.remove(key);
        if (null != oldValue) {
            this.mKeyQueue.remove(key);
            if (null != this.mHandler) {
                this.mHandler.onInvalidated(key, oldValue);
            }
        }
    }

    public void invalidate(K key, V value) {
        if (this.mKey2Value.remove(key, value)) {
            this.mKeyQueue.remove(key);
            if (null != this.mHandler) {
                this.mHandler.onInvalidated(key, value);
            }
        }
    }

    public void clear() {
        for (K key : this.mKeyQueue) {
            this.invalidate(key);
        }
    }

    private void expireOldestIfOverCapacity() {
        K key;
        while (this.mKey2Value.size() > this.mCapacity && null != (key = this.mKeyQueue.poll())) {
            V value = this.mKey2Value.remove(key);
            if (null == value || null == this.mHandler) continue;
            this.mHandler.onExpired(key, value);
        }
    }

    public static interface IRemovalHandler<K, V> {
        public void onExpired(K var1, V var2);

        public void onReplaced(K var1, V var2);

        public void onInvalidated(K var1, V var2);
    }
}

