/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import com.ibm.neo.util.ArrayKey;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class NumberFormatPool {
    private static final ThreadLocal<NumberFormatPool> LOCAL = new ThreadLocal<NumberFormatPool>(){

        @Override
        protected NumberFormatPool initialValue() {
            return new NumberFormatPool();
        }
    };
    private final Map<ArrayKey, NumberFormat> mKey2Instance = new HashMap<ArrayKey, NumberFormat>();

    public static NumberFormat getInstance(ULocale locale, int style) {
        NumberFormatPool pool = LOCAL.get();
        ArrayKey key = new ArrayKey(locale, style);
        NumberFormat format = pool.mKey2Instance.get(key);
        if (null == format) {
            format = NumberFormat.getInstance((ULocale)locale, (int)style);
            pool.mKey2Instance.put(key, format);
        }
        return format;
    }

    public static NumberFormat getInstance(Locale locale, int style) {
        return NumberFormatPool.getInstance(ULocale.forLocale((Locale)locale), style);
    }

    public static NumberFormat getInstance(ULocale locale) {
        return NumberFormatPool.getInstance(locale, 0);
    }

    public static NumberFormat getInstance(Locale locale) {
        return NumberFormatPool.getInstance(locale, 0);
    }

    public static NumberFormat getCurrencyInstance(ULocale locale) {
        return NumberFormatPool.getInstance(locale, 1);
    }

    public static NumberFormat getCurrencyInstance(Locale locale) {
        return NumberFormatPool.getInstance(locale, 1);
    }

    public static NumberFormat getISOCurrencyInstance(ULocale locale) {
        return NumberFormatPool.getInstance(locale, 5);
    }

    public static NumberFormat getISOCurrencyInstance(Locale locale) {
        return NumberFormatPool.getInstance(locale, 5);
    }

    public static NumberFormat getIntegerInstance(ULocale locale) {
        return NumberFormatPool.getInstance(locale, 4);
    }

    public static NumberFormat getIntegerInstance(Locale locale) {
        return NumberFormatPool.getInstance(locale, 4);
    }

    public static NumberFormat getPercentInstance(ULocale locale) {
        return NumberFormatPool.getInstance(locale, 2);
    }

    public static NumberFormat getPercentInstance(Locale locale) {
        return NumberFormatPool.getInstance(locale, 2);
    }

    public static NumberFormat getScientificInstance(ULocale locale) {
        return NumberFormatPool.getInstance(locale, 1);
    }

    public static NumberFormat getScientificInstance(Locale locale) {
        return NumberFormatPool.getInstance(locale, 1);
    }
}

