/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util;

import java.util.Iterator;
import org.apache.commons.lang.NullArgumentException;

public class ObservableCountingIterator<T>
implements Iterator<T> {
    private final Iterator<T> mIterator;
    private final IIterationCountObserver mObserver;
    private final long mMilestoneSize;
    private long mNextMilestone;
    private long mCurrentCount;
    private long mLastCount;
    private boolean mSentFinalNotification;

    public ObservableCountingIterator(Iterator<T> iterator, IIterationCountObserver observer) {
        this(iterator, observer, -1L);
    }

    public ObservableCountingIterator(Iterator<T> iterator, IIterationCountObserver observer, long milestoneSize) {
        if (null == observer) {
            throw new NullArgumentException("observer");
        }
        if (milestoneSize == 0L || milestoneSize < -1L) {
            throw new IllegalArgumentException("milestoneSize == 0 or < -1");
        }
        this.mIterator = iterator;
        this.mObserver = observer;
        this.mMilestoneSize = milestoneSize;
        this.mNextMilestone = milestoneSize == -1L ? 0L : this.mMilestoneSize;
        this.mCurrentCount = 0L;
        this.mLastCount = 0L;
        this.mSentFinalNotification = false;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.mIterator.hasNext();
        if (!hasNext && !this.mSentFinalNotification) {
            this.mSentFinalNotification = true;
            this.notifyObserverIfRequired(true);
        }
        return hasNext;
    }

    @Override
    public T next() {
        ++this.mCurrentCount;
        T next = this.mIterator.next();
        this.notifyObserverIfRequired(false);
        return next;
    }

    @Override
    public void remove() {
        this.mIterator.remove();
    }

    private void notifyObserverIfRequired(boolean force) {
        long count = this.mCurrentCount;
        if (this.mMilestoneSize < 1L || force) {
            this.mObserver.onIterationCountChanged(count - this.mLastCount, count);
            this.mLastCount = count;
        } else if (count >= this.mNextMilestone) {
            this.mNextMilestone = count + this.mMilestoneSize;
            this.mObserver.onIterationCountChanged(count - this.mLastCount, count);
            this.mLastCount = count;
        }
    }

    public static interface IIterationCountObserver {
        public void onIterationCountChanged(long var1, long var3);
    }
}

