/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util;

import com.ibm.neo.util.IObserver;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservableHelper<S> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObservableHelper.class);
    private final LinkedList<IObserver<S>> mObservers = new LinkedList();

    public synchronized void addObserver(IObserver<S> observer) {
        this.mObservers.add(observer);
    }

    public synchronized void removeObserver(IObserver<S> observer) {
        this.mObservers.remove(observer);
    }

    public synchronized <T> void updateObservers(S subject) {
        for (IObserver iObserver : this.mObservers) {
            try {
                iObserver.updated(subject);
            }
            catch (Throwable t) {
                LOGGER.error("Unhandled exception from observer", t);
            }
        }
    }
}

