/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util;

import com.ibm.neo.util.Assertions;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ReservationTTLCache<K, V> {
    private final ConcurrentHashMap<K, CacheEntry<K, V>> mKey2Entry = new ConcurrentHashMap();
    private final IRemovalHandler<K, V> mRemovalHandler;
    private final long mExpirationPeriodNanos;

    public ReservationTTLCache(long expirationPeriod, TimeUnit expirationUnit) {
        this(expirationPeriod, expirationUnit, null);
    }

    public ReservationTTLCache(long expirationPeriod, TimeUnit expirationUnit, IRemovalHandler<K, V> removalHandler) {
        if (expirationPeriod <= 0L) {
            throw new IllegalArgumentException("expirationPeriod <= 0");
        }
        if (null == expirationUnit) {
            throw new NullArgumentException("expirationUnit");
        }
        this.mExpirationPeriodNanos = expirationUnit.toNanos(expirationPeriod);
        this.mRemovalHandler = removalHandler;
    }

    public Reservation<V> reserve(K key) {
        this.checkExpiredEntries();
        CacheEntry<K, V> e = this.mKey2Entry.get(key);
        if (null != e && e.tryReserve()) {
            return new Reservation(e);
        }
        return null;
    }

    public void put(K key, V value) throws LockedByReservation {
        this.checkExpiredEntries();
        if (null == key) {
            throw new NullArgumentException("key");
        }
        CacheEntry<K, V> e = new CacheEntry<K, V>(this, key, value);
        CacheEntry<K, V> old = this.mKey2Entry.putIfAbsent(key, e);
        if (null != old) {
            if (old.tryRelease()) {
                this.mKey2Entry.remove(key, old);
                this.mKey2Entry.putIfAbsent(key, e);
            } else {
                throw new LockedByReservation();
            }
        }
    }

    public void remove(K key) throws LockedByReservation {
        this.checkExpiredEntries();
        if (null == key) {
            throw new NullArgumentException("key");
        }
        CacheEntry<K, V> e = this.mKey2Entry.get(key);
        if (null == e) {
            return;
        }
        if (!e.tryRelease()) {
            throw new LockedByReservation();
        }
        this.mKey2Entry.remove(key, e);
    }

    public void remove(K key, V value) throws LockedByReservation {
        this.checkExpiredEntries();
        if (null == key) {
            throw new NullArgumentException("key");
        }
        CacheEntry<K, V> e = this.mKey2Entry.get(key);
        if (null == e) {
            return;
        }
        if (!ReservationTTLCache.isEqualTo(value, e.getValue())) {
            return;
        }
        if (!e.tryRelease()) {
            throw new LockedByReservation();
        }
        this.mKey2Entry.remove(key, e);
    }

    public void clear(boolean force) throws LockedByReservation {
        if (force) {
            for (CacheEntry<K, V> e : this.mKey2Entry.values()) {
                e.forceRelease();
            }
            this.mKey2Entry.clear();
        } else {
            for (CacheEntry<K, V> e : this.mKey2Entry.values()) {
                if (e.tryRelease()) {
                    this.mKey2Entry.remove(e.getKey(), e);
                    continue;
                }
                throw new LockedByReservation();
            }
        }
    }

    private void checkExpiredEntries() {
        Iterator<CacheEntry<K, V>> iter = this.mKey2Entry.values().iterator();
        while (iter.hasNext()) {
            CacheEntry<K, V> e = iter.next();
            if (!e.tryExpire()) continue;
            iter.remove();
        }
    }

    public String toString() {
        return this.mKey2Entry.toString();
    }

    private static boolean isEqualTo(Object left, Object right) {
        if (null == left) {
            return null == right;
        }
        if (null == right) {
            return false;
        }
        return left.equals(right);
    }

    private static final class CacheEntry<K, V> {
        private final ReservationTTLCache<K, V> mCache;
        private final K mKey;
        private final V mValue;
        private final AtomicInteger mUseCount = new AtomicInteger(0);
        private long mExpiresOnNanos = 0L;

        CacheEntry(ReservationTTLCache<K, V> cache, K key, V value) {
            this.mCache = cache;
            this.mKey = key;
            this.mValue = value;
            this.mExpiresOnNanos = System.nanoTime() + ((ReservationTTLCache)this.mCache).mExpirationPeriodNanos;
        }

        K getKey() {
            return this.mKey;
        }

        V getValue() {
            return this.mValue;
        }

        boolean tryReserve() {
            int count;
            do {
                if (System.nanoTime() > this.mExpiresOnNanos) {
                    return false;
                }
                count = this.mUseCount.get();
                if (count != Integer.MIN_VALUE) continue;
                return false;
            } while (!this.mUseCount.compareAndSet(count, count + 1));
            this.mExpiresOnNanos = System.nanoTime() + ((ReservationTTLCache)this.mCache).mExpirationPeriodNanos;
            return true;
        }

        void unreserve() {
            Assertions.assertPositive(this.mUseCount.decrementAndGet());
        }

        boolean tryExpire() {
            if (System.nanoTime() > this.mExpiresOnNanos) {
                return this.tryRelease();
            }
            return false;
        }

        boolean tryRelease() {
            block3: {
                int count;
                do {
                    if ((count = this.mUseCount.get()) == Integer.MIN_VALUE) {
                        return true;
                    }
                    if (count != 0) break block3;
                } while (!this.mUseCount.compareAndSet(count, Integer.MIN_VALUE));
                if (null != ((ReservationTTLCache)this.mCache).mRemovalHandler) {
                    ((ReservationTTLCache)this.mCache).mRemovalHandler.onRemoved(this.mKey, this.mValue);
                }
                return true;
            }
            return false;
        }

        void forceRelease() {
            this.mUseCount.set(Integer.MIN_VALUE);
            if (null != ((ReservationTTLCache)this.mCache).mRemovalHandler) {
                ((ReservationTTLCache)this.mCache).mRemovalHandler.onRemoved(this.mKey, this.mValue);
            }
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("key", this.mKey).append("value", this.mValue).append("useCount", this.mUseCount.get()).toString();
        }
    }

    public static final class LockedByReservation
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static final class Reservation<V> {
        private final CacheEntry<?, V> mEntry;
        private boolean mReleased = false;

        private Reservation(CacheEntry<?, V> entry) {
            this.mEntry = entry;
        }

        public V getValue() {
            if (this.mReleased) {
                throw new IllegalStateException("Reservation was released");
            }
            return this.mEntry.getValue();
        }

        public void release() {
            if (this.mReleased) {
                return;
            }
            this.mReleased = true;
            this.mEntry.unreserve();
        }

        public boolean isReleased() {
            return this.mReleased;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("entry", this.mEntry).append("released", this.mReleased).toString();
        }
    }

    public static interface IRemovalHandler<K, V> {
        public void onRemoved(K var1, V var2);
    }
}

