/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util;

import com.ibm.neo.io.FastBufferedReader;
import com.ibm.neo.io.FastInputStreamReader;
import com.ibm.neo.io.VarIntCoder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;

public class StringDictionary {
    private static final Charset CHARSET = Charset.forName("UTF8");
    private final ArrayList<String> mTable = new ArrayList(256);
    private volatile HashMap<String, Integer> mReverseTable;

    public int size() {
        return this.mTable.size();
    }

    public String lookup(int id) {
        if (-1 == id) {
            return null;
        }
        return this.mTable.get(id);
    }

    public int reverseLookup(String str) {
        Integer id;
        if (null == this.mReverseTable) {
            this.buildReverseTable();
        }
        if (null != (id = this.mReverseTable.get(str))) {
            return id;
        }
        return -1;
    }

    public int reverseLookupOrInsert(String str) {
        Integer existingId;
        if (null == this.mReverseTable) {
            this.buildReverseTable();
        }
        if ((existingId = this.mReverseTable.get(str)) != null) {
            return existingId;
        }
        Integer newId = this.mTable.size();
        this.mReverseTable.put(str, newId);
        this.mTable.add(str);
        return newId;
    }

    public String internalize(String str) {
        int id = this.reverseLookupOrInsert(str);
        return this.lookup(id);
    }

    public void clear() {
        this.mTable.clear();
        this.mReverseTable = null;
    }

    public void writeTo(OutputStream out) throws IOException {
        VarIntCoder.writeUnsignedVarInt(this.mTable.size(), out);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, CHARSET), 4096);
        for (String s : this.mTable) {
            writer.append(s);
            writer.append('\u0000');
        }
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.writeTo(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFrom(InputStream in) throws IOException {
        int size = VarIntCoder.readUnsignedVarInt(in);
        FastBufferedReader reader = new FastBufferedReader(new FastInputStreamReader(in, CHARSET), 4096);
        char[] buffer = new char[4096];
        int len = 0;
        try {
            int chr;
            this.clear();
            this.mTable.ensureCapacity(size);
            while ((chr = reader.read()) >= 0) {
                if (0 == chr) {
                    this.mTable.add(new String(buffer, 0, len));
                    len = 0;
                    continue;
                }
                if (buffer.length <= len) {
                    char[] oldBuffer = buffer;
                    buffer = new char[len * 2];
                    System.arraycopy(oldBuffer, 0, buffer, 0, oldBuffer.length);
                }
                buffer[len++] = (char)(chr & 0xFFFF);
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFrom(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            this.readFrom(in);
        }
    }

    private void buildReverseTable() {
        HashMap<String, Integer> map = new HashMap<String, Integer>(Math.max(256, this.mTable.size()));
        for (int i = 0; i < this.mTable.size(); ++i) {
            map.put(this.mTable.get(i), i);
        }
        this.mReverseTable = map;
    }
}

